<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle ?? 'InvoiceApp') ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        :root { --sidebar-width: 250px; --primary: #2563eb; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif; background: #f1f5f9; }
        .sidebar { position: fixed; top: 0; left: 0; width: var(--sidebar-width); height: 100vh; background: #1e293b; color: #e2e8f0; overflow-y: auto; z-index: 1000; transition: transform .3s; }
        .sidebar .brand { padding: 1.25rem; font-size: 1.25rem; font-weight: 700; border-bottom: 1px solid #334155; display: flex; align-items: center; gap: .5rem; }
        .sidebar .brand i { color: var(--primary); }
        .sidebar-nav { padding: .5rem 0; }
        .sidebar-nav .nav-section { padding: .75rem 1.25rem .25rem; font-size: .7rem; text-transform: uppercase; letter-spacing: .08em; color: #64748b; }
        .sidebar-nav a { display: flex; align-items: center; gap: .625rem; padding: .5rem 1.25rem; color: #cbd5e1; text-decoration: none; font-size: .875rem; transition: all .15s; }
        .sidebar-nav a:hover, .sidebar-nav a.active { background: #334155; color: #fff; }
        .sidebar-nav a.active { border-right: 3px solid var(--primary); }
        .sidebar-nav a i { width: 1.25rem; text-align: center; }
        .main-content { margin-left: var(--sidebar-width); min-height: 100vh; }
        .top-bar { background: #fff; border-bottom: 1px solid #e2e8f0; padding: .75rem 1.5rem; display: flex; justify-content: space-between; align-items: center; }
        .top-bar .user-info { display: flex; align-items: center; gap: .5rem; }
        .content-area { padding: 1.5rem; }
        .stat-card { background: #fff; border-radius: .5rem; padding: 1.25rem; border: 1px solid #e2e8f0; }
        .stat-card .stat-value { font-size: 1.75rem; font-weight: 700; color: #1e293b; }
        .stat-card .stat-label { color: #64748b; font-size: .8125rem; }
        .stat-card .stat-icon { width: 48px; height: 48px; border-radius: .5rem; display: flex; align-items: center; justify-content: center; font-size: 1.25rem; }
        .card { border: 1px solid #e2e8f0; border-radius: .5rem; box-shadow: none; }
        .card-header { background: #fff; border-bottom: 1px solid #e2e8f0; font-weight: 600; }
        .table th { font-size: .8125rem; font-weight: 600; color: #64748b; text-transform: uppercase; letter-spacing: .05em; border-bottom-width: 1px; }
        .btn-primary { background: var(--primary); border-color: var(--primary); }
        .btn-primary:hover { background: #1d4ed8; border-color: #1d4ed8; }
        .badge { font-weight: 500; }
        .empty-state { text-align: center; padding: 3rem 1rem; color: #94a3b8; }
        .empty-state i { font-size: 3rem; margin-bottom: 1rem; }
        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; }
        }
    </style>
    <?= $extraHead ?? '' ?>
</head>
<body>
    <!-- Sidebar -->
    <nav class="sidebar" id="sidebar">
        <div class="brand">
            <i class="bi bi-receipt-cutoff"></i>
            <span>InvoiceApp</span>
        </div>
        <div class="sidebar-nav">
            <div class="nav-section">Overzicht</div>
            <a href="/dashboard" class="<?= ($currentPage ?? '') === 'dashboard' ? 'active' : '' ?>">
                <i class="bi bi-grid-1x2"></i> Dashboard
            </a>

            <div class="nav-section">Verkoop</div>
            <?php if (Auth::hasPermission('customers', 'view')): ?>
            <a href="/customers" class="<?= ($currentPage ?? '') === 'customers' ? 'active' : '' ?>">
                <i class="bi bi-people"></i> Klanten
            </a>
            <?php endif; ?>
            <?php if (Auth::hasPermission('items', 'view')): ?>
            <a href="/items" class="<?= ($currentPage ?? '') === 'items' ? 'active' : '' ?>">
                <i class="bi bi-box-seam"></i> Producten/Diensten
            </a>
            <?php endif; ?>
            <?php if (Auth::hasPermission('quotes', 'view')): ?>
            <a href="/quotes" class="<?= ($currentPage ?? '') === 'quotes' ? 'active' : '' ?>">
                <i class="bi bi-file-earmark-text"></i> Offertes
            </a>
            <?php endif; ?>

            <div class="nav-section">Facturatie</div>
            <?php if (Auth::hasPermission('invoices', 'view')): ?>
            <a href="/invoices" class="<?= ($currentPage ?? '') === 'invoices' ? 'active' : '' ?>">
                <i class="bi bi-receipt"></i> Facturen
            </a>
            <?php endif; ?>
            <?php if (Auth::hasPermission('credits', 'view')): ?>
            <a href="/credits" class="<?= ($currentPage ?? '') === 'credits' ? 'active' : '' ?>">
                <i class="bi bi-file-earmark-minus"></i> Creditnota's
            </a>
            <?php endif; ?>
            <?php if (Auth::hasPermission('payments', 'view')): ?>
            <a href="/payments" class="<?= ($currentPage ?? '') === 'payments' ? 'active' : '' ?>">
                <i class="bi bi-cash-stack"></i> Betalingen
            </a>
            <?php endif; ?>
            <?php if (Auth::hasPermission('reminders', 'view')): ?>
            <a href="/reminders" class="<?= ($currentPage ?? '') === 'reminders' ? 'active' : '' ?>">
                <i class="bi bi-bell"></i> Herinneringen
            </a>
            <?php endif; ?>

            <div class="nav-section">Analyse</div>
            <?php if (Auth::hasPermission('reports', 'view')): ?>
            <a href="/reports" class="<?= ($currentPage ?? '') === 'reports' ? 'active' : '' ?>">
                <i class="bi bi-bar-chart-line"></i> Rapportages
            </a>
            <?php endif; ?>
            <?php if (Auth::hasPermission('audit', 'view')): ?>
            <a href="/audit" class="<?= ($currentPage ?? '') === 'audit' ? 'active' : '' ?>">
                <i class="bi bi-clock-history"></i> Audit Log
            </a>
            <?php endif; ?>

            <div class="nav-section">Beheer</div>
            <?php if (Auth::hasPermission('settings', 'view')): ?>
            <a href="/settings" class="<?= ($currentPage ?? '') === 'settings' ? 'active' : '' ?>">
                <i class="bi bi-gear"></i> Instellingen
            </a>
            <?php endif; ?>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="main-content">
        <div class="top-bar">
            <div>
                <button class="btn btn-sm btn-outline-secondary d-md-none" onclick="document.getElementById('sidebar').classList.toggle('show')">
                    <i class="bi bi-list"></i>
                </button>
                <span class="fw-semibold ms-2"><?= e($pageTitle ?? '') ?></span>
            </div>
            <div class="user-info">
                <span class="text-muted small"><?= e($user['name'] ?? '') ?></span>
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><span class="dropdown-item-text small text-muted"><?= e($user['email'] ?? '') ?></span></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="/settings"><i class="bi bi-gear me-2"></i>Instellingen</a></li>
                        <li><a class="dropdown-item text-danger" href="/logout"><i class="bi bi-box-arrow-right me-2"></i>Uitloggen</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="content-area">
            <!-- Flash messages -->
            <?php foreach ($flash as $msg): ?>
            <div class="alert alert-<?= e($msg['type']) ?> alert-dismissible fade show" role="alert">
                <?= e($msg['message']) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endforeach; ?>

            <!-- Page content -->
            <?= $content ?? '' ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?= $extraScripts ?? '' ?>
</body>
</html>
