<div class="flex items-center justify-between mb-6">
    <form method="GET" action="/items" class="flex items-center gap-2">
        <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Zoek product/dienst..." class="form-input" style="width: 280px;">
        <button type="submit" class="btn-secondary btn-sm"><i class="fas fa-search"></i></button>
        <?php if ($search): ?><a href="/items" class="text-sm text-gray-500">Wissen</a><?php endif; ?>
    </form>
    <a href="/items/create" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nieuw product</a>
</div>
<div class="card">
    <table>
        <thead><tr><th>SKU</th><th>Naam</th><th>Eenheid</th><th class="text-right">Prijs</th><th>BTW</th><th>Status</th><th class="text-right">Acties</th></tr></thead>
        <tbody>
        <?php if (empty($items)): ?>
            <tr><td colspan="7" class="text-center text-gray-400 py-8">Geen producten gevonden</td></tr>
        <?php else: foreach ($items as $item): ?>
            <tr class="<?= !$item['is_active'] ? 'opacity-50' : '' ?>">
                <td class="text-sm text-gray-500"><?= htmlspecialchars($item['sku'] ?? '-') ?></td>
                <td class="font-medium"><?= htmlspecialchars($item['name']) ?></td>
                <td><?= htmlspecialchars($item['unit']) ?></td>
                <td class="text-right font-medium"><?= $this->formatMoney((float)$item['unit_price']) ?></td>
                <td><?php $tr = $taxMap[$item['tax_rate_id']] ?? null; echo $tr ? htmlspecialchars($tr['name'].' ('.$tr['rate'].'%)') : '-'; ?></td>
                <td><span class="badge <?= $item['is_active'] ? 'badge-green' : 'badge-gray' ?>"><?= $item['is_active'] ? 'Actief' : 'Inactief' ?></span></td>
                <td class="text-right">
                    <a href="/items/<?= $item['id'] ?>/edit" class="text-gray-400 hover:text-blue-600 mr-2"><i class="fas fa-edit"></i></a>
                    <form method="POST" action="/items/<?= $item['id'] ?>/delete" class="inline" onsubmit="return confirm('Product verwijderen?')">
                        <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                        <button type="submit" class="text-gray-400 hover:text-red-600"><i class="fas fa-trash"></i></button>
                    </form>
                </td>
            </tr>
        <?php endforeach; endif; ?>
        </tbody>
    </table>
</div>
