<?php $isEdit = !empty($item); ?>
<form method="POST" action="<?= $isEdit ? "/items/{$item['id']}" : '/items' ?>">
    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
    <div class="max-w-2xl">
        <div class="card p-6">
            <h3 class="text-lg font-semibold mb-4">Product/Dienst gegevens</h3>
            <div class="grid grid-cols-2 gap-4">
                <div class="col-span-2"><label class="form-label">Naam *</label><input type="text" name="name" class="form-input" required value="<?= htmlspecialchars($item['name'] ?? '') ?>"></div>
                <div><label class="form-label">SKU / Artikelcode</label><input type="text" name="sku" class="form-input" value="<?= htmlspecialchars($item['sku'] ?? '') ?>"></div>
                <div><label class="form-label">Eenheid</label>
                    <select name="unit" class="form-input">
                        <?php foreach (['stuk'=>'Stuk','uur'=>'Uur','dag'=>'Dag','maand'=>'Maand','m2'=>'m²','kg'=>'Kilogram','liter'=>'Liter'] as $v => $l): ?>
                        <option value="<?= $v ?>" <?= ($item['unit'] ?? 'stuk') === $v ? 'selected' : '' ?>><?= $l ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div><label class="form-label">Prijs (excl. BTW) *</label><input type="number" name="unit_price" class="form-input" step="0.01" min="0" required value="<?= htmlspecialchars($item['unit_price'] ?? '0.00') ?>"></div>
                <div><label class="form-label">BTW-tarief</label>
                    <select name="tax_rate_id" class="form-input">
                        <option value="">-- Geen --</option>
                        <?php foreach ($taxRates as $tr): ?>
                        <option value="<?= $tr['id'] ?>" <?= ($item['tax_rate_id'] ?? '') == $tr['id'] ? 'selected' : '' ?>><?= htmlspecialchars($tr['name'].' ('.$tr['rate'].'%)') ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-span-2"><label class="form-label">Omschrijving</label><textarea name="description" class="form-input" rows="3"><?= htmlspecialchars($item['description'] ?? '') ?></textarea></div>
                <div><label class="flex items-center gap-2"><input type="checkbox" name="is_active" value="1" <?= ($item['is_active'] ?? 1) ? 'checked' : '' ?>> Actief</label></div>
            </div>
            <div class="flex gap-3 mt-6">
                <button type="submit" class="btn-primary"><i class="fas fa-save mr-2"></i><?= $isEdit ? 'Opslaan' : 'Aanmaken' ?></button>
                <a href="/items" class="btn-secondary">Annuleren</a>
            </div>
        </div>
    </div>
</form>
