<?php
$statusLabels = ['draft'=>'Concept','final'=>'Definitief','sent'=>'Verzonden','overdue'=>'Verlopen','partially_paid'=>'Deels betaald','paid'=>'Betaald','cancelled'=>'Geannuleerd'];
$statusBadges = ['draft'=>'badge-gray','final'=>'badge-blue','sent'=>'badge-blue','overdue'=>'badge-red','partially_paid'=>'badge-yellow','paid'=>'badge-green','cancelled'=>'badge-gray'];
?>

<div class="flex items-center justify-between mb-6">
    <div class="flex items-center gap-3">
        <form method="GET" action="/invoices" class="flex items-center gap-2">
            <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Zoek factuur of klant..." class="form-input" style="width: 260px;">
            <select name="status" class="form-input" style="width: 180px;" onchange="this.form.submit()">
                <option value="">Alle statussen</option>
                <?php foreach ($statusLabels as $k => $v): ?>
                <option value="<?= $k ?>" <?= $status === $k ? 'selected' : '' ?>><?= $v ?> (<?= $statusCounts[$k] ?? 0 ?>)</option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="btn-secondary btn-sm"><i class="fas fa-search"></i></button>
        </form>
    </div>
    <a href="/invoices/create" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nieuwe factuur</a>
</div>

<div class="card">
    <table>
        <thead><tr><th>Nummer</th><th>Klant</th><th>Datum</th><th>Vervaldatum</th><th class="text-right">Bedrag</th><th class="text-right">Openstaand</th><th>Status</th><th class="text-right">Acties</th></tr></thead>
        <tbody>
        <?php if (empty($invoices)): ?>
            <tr><td colspan="8" class="text-center text-gray-400 py-8">Geen facturen gevonden</td></tr>
        <?php else: foreach ($invoices as $inv): ?>
            <tr>
                <td><a href="/invoices/<?= $inv['id'] ?>" class="text-blue-600 font-medium hover:underline"><?= htmlspecialchars($inv['invoice_number'] ?: 'CONCEPT') ?></a></td>
                <td><?= htmlspecialchars($inv['customer_name'] ?? '-') ?></td>
                <td><?= $inv['issue_date'] ? date('d-m-Y', strtotime($inv['issue_date'])) : '-' ?></td>
                <td class="<?= ($inv['due_date'] && strtotime($inv['due_date']) < time() && $inv['status'] !== 'paid') ? 'text-red-600 font-medium' : '' ?>"><?= $inv['due_date'] ? date('d-m-Y', strtotime($inv['due_date'])) : '-' ?></td>
                <td class="text-right font-medium"><?= $this->formatMoney((float)$inv['total']) ?></td>
                <td class="text-right <?= $inv['amount_due'] > 0 ? 'text-amber-600 font-medium' : 'text-green-600' ?>"><?= $this->formatMoney((float)$inv['amount_due']) ?></td>
                <td><span class="badge <?= $statusBadges[$inv['status']] ?? 'badge-gray' ?>"><?= $statusLabels[$inv['status']] ?? $inv['status'] ?></span></td>
                <td class="text-right">
                    <a href="/invoices/<?= $inv['id'] ?>" class="text-gray-400 hover:text-blue-600" title="Bekijken"><i class="fas fa-eye"></i></a>
                    <?php if ($inv['status'] === 'draft'): ?>
                        <a href="/invoices/<?= $inv['id'] ?>/edit" class="text-gray-400 hover:text-blue-600 ml-2" title="Bewerken"><i class="fas fa-edit"></i></a>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; endif; ?>
        </tbody>
    </table>
    <?php if ($pagination['total_pages'] > 1): ?>
    <div class="px-6 py-4 border-t flex items-center justify-between">
        <span class="text-sm text-gray-500"><?= $pagination['total'] ?> facturen</span>
        <div class="flex gap-1">
            <?php for ($p = 1; $p <= $pagination['total_pages']; $p++): ?>
            <a href="?page=<?= $p ?>&status=<?= urlencode($status) ?>&search=<?= urlencode($search) ?>" class="px-3 py-1 rounded text-sm <?= $p === $pagination['page'] ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' ?>"><?= $p ?></a>
            <?php endfor; ?>
        </div>
    </div>
    <?php endif; ?>
</div>
