<?php $isEdit = !empty($invoice); ?>
<form method="POST" action="<?= $isEdit ? "/invoices/{$invoice['id']}" : '/invoices' ?>" id="invoiceForm">
    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
    <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
        <div class="lg:col-span-3">
            <div class="card p-6 mb-6">
                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <label class="form-label">Klant *</label>
                        <select name="customer_id" class="form-input" required>
                            <option value="">-- Selecteer klant --</option>
                            <?php foreach ($customers as $c): ?>
                            <option value="<?= $c['id'] ?>" <?= ($selectedCustomer ?? ($invoice['customer_id'] ?? '')) == $c['id'] ? 'selected' : '' ?>><?= htmlspecialchars($c['company_name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="form-label">Factuurdatum</label>
                        <input type="date" name="issue_date" class="form-input" value="<?= htmlspecialchars($invoice['issue_date'] ?? date('Y-m-d')) ?>">
                    </div>
                    <div>
                        <label class="form-label">Vervaldatum</label>
                        <input type="date" name="due_date" class="form-input" value="<?= htmlspecialchars($invoice['due_date'] ?? date('Y-m-d', strtotime('+'.($settings['default_payment_terms'] ?? 30).' days'))) ?>">
                    </div>
                </div>
            </div>

            <!-- Invoice Lines -->
            <div class="card p-6 mb-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold">Factuurregels</h3>
                    <button type="button" onclick="addLine()" class="btn-secondary btn-sm"><i class="fas fa-plus mr-1"></i> Regel toevoegen</button>
                </div>
                <table class="w-full" id="linesTable">
                    <thead>
                        <tr class="text-xs text-gray-500 uppercase">
                            <th class="text-left pb-2" style="width:35%">Omschrijving</th>
                            <th class="text-center pb-2" style="width:10%">Aantal</th>
                            <th class="text-left pb-2" style="width:10%">Eenheid</th>
                            <th class="text-right pb-2" style="width:15%">Prijs</th>
                            <th class="text-center pb-2" style="width:10%">BTW%</th>
                            <th class="text-right pb-2" style="width:15%">Totaal</th>
                            <th style="width:5%"></th>
                        </tr>
                    </thead>
                    <tbody id="linesBody">
                        <?php if (!empty($lines)): ?>
                            <?php foreach ($lines as $i => $line): ?>
                            <tr class="line-row border-t">
                                <td class="py-2 pr-2">
                                    <input type="hidden" name="line_item_id[]" value="<?= $line['item_id'] ?? '' ?>">
                                    <input type="text" name="line_description[]" class="form-input" value="<?= htmlspecialchars($line['description']) ?>" required>
                                </td>
                                <td class="py-2 px-1"><input type="number" name="line_quantity[]" class="form-input text-center" step="0.01" min="0" value="<?= $line['quantity'] ?>" onchange="calcLine(this)"></td>
                                <td class="py-2 px-1"><input type="text" name="line_unit[]" class="form-input" value="<?= htmlspecialchars($line['unit']) ?>"></td>
                                <td class="py-2 px-1"><input type="number" name="line_unit_price[]" class="form-input text-right" step="0.01" value="<?= $line['unit_price'] ?>" onchange="calcLine(this)"></td>
                                <td class="py-2 px-1"><input type="number" name="line_tax_rate[]" class="form-input text-center" step="0.01" value="<?= $line['tax_rate'] ?>" onchange="calcLine(this)"></td>
                                <td class="py-2 px-1 text-right font-medium line-total"><?= number_format($line['line_total'], 2, ',', '.') ?></td>
                                <td class="py-2 pl-1"><button type="button" onclick="removeLine(this)" class="text-red-400 hover:text-red-600"><i class="fas fa-times"></i></button></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>

                <!-- Quick add from catalog -->
                <div class="mt-4 flex items-center gap-2">
                    <select id="quickAddItem" class="form-input" style="width: 300px;">
                        <option value="">+ Kies uit catalogus...</option>
                        <?php foreach ($items as $item): ?>
                        <option value="<?= $item['id'] ?>" data-name="<?= htmlspecialchars($item['name']) ?>" data-desc="<?= htmlspecialchars($item['description'] ?? $item['name']) ?>" data-price="<?= $item['unit_price'] ?>" data-unit="<?= htmlspecialchars($item['unit']) ?>" data-tax="<?= $item['tax_rate_value'] ?? 21 ?>">
                            <?= htmlspecialchars($item['name']) ?> - <?= number_format($item['unit_price'], 2, ',', '.') ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                    <button type="button" onclick="addFromCatalog()" class="btn-secondary btn-sm">Toevoegen</button>
                </div>

                <!-- Totals -->
                <div class="mt-6 border-t pt-4">
                    <div class="flex justify-end">
                        <div class="w-64 space-y-2">
                            <div class="flex justify-between text-sm"><span class="text-gray-500">Subtotaal:</span><span id="subtotal" class="font-medium">€ 0,00</span></div>
                            <div class="flex justify-between text-sm"><span class="text-gray-500">BTW:</span><span id="taxtotal" class="font-medium">€ 0,00</span></div>
                            <div class="flex justify-between text-lg border-t pt-2"><span class="font-semibold">Totaal:</span><span id="grandtotal" class="font-bold text-blue-600">€ 0,00</span></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div>
            <div class="card p-6 mb-6">
                <h3 class="font-semibold mb-3">Notities</h3>
                <textarea name="notes" class="form-input" rows="4" placeholder="Interne/externe notities..."><?= htmlspecialchars($invoice['notes'] ?? '') ?></textarea>
            </div>
            <div class="card p-6 mb-6">
                <h3 class="font-semibold mb-3">Voettekst factuur</h3>
                <textarea name="footer_text" class="form-input" rows="3" placeholder="Wordt onderaan PDF getoond..."><?= htmlspecialchars($invoice['footer_text'] ?? '') ?></textarea>
            </div>
            <div class="space-y-3">
                <button type="submit" class="btn-primary w-full"><i class="fas fa-save mr-2"></i><?= $isEdit ? 'Opslaan' : 'Opslaan als concept' ?></button>
                <a href="/invoices" class="btn-secondary w-full text-center block">Annuleren</a>
            </div>
        </div>
    </div>
</form>

<script>
function addLine(desc='', qty=1, unit='stuk', price=0, tax=21, itemId='') {
    const row = document.createElement('tr');
    row.className = 'line-row border-t';
    row.innerHTML = `
        <td class="py-2 pr-2"><input type="hidden" name="line_item_id[]" value="${itemId}"><input type="text" name="line_description[]" class="form-input" value="${desc}" required></td>
        <td class="py-2 px-1"><input type="number" name="line_quantity[]" class="form-input text-center" step="0.01" min="0" value="${qty}" onchange="calcLine(this)"></td>
        <td class="py-2 px-1"><input type="text" name="line_unit[]" class="form-input" value="${unit}"></td>
        <td class="py-2 px-1"><input type="number" name="line_unit_price[]" class="form-input text-right" step="0.01" value="${price}" onchange="calcLine(this)"></td>
        <td class="py-2 px-1"><input type="number" name="line_tax_rate[]" class="form-input text-center" step="0.01" value="${tax}" onchange="calcLine(this)"></td>
        <td class="py-2 px-1 text-right font-medium line-total">0,00</td>
        <td class="py-2 pl-1"><button type="button" onclick="removeLine(this)" class="text-red-400 hover:text-red-600"><i class="fas fa-times"></i></button></td>
    `;
    document.getElementById('linesBody').appendChild(row);
    calcTotals();
}

function addFromCatalog() {
    const sel = document.getElementById('quickAddItem');
    const opt = sel.options[sel.selectedIndex];
    if (!opt.value) return;
    addLine(opt.dataset.desc, 1, opt.dataset.unit, opt.dataset.price, opt.dataset.tax, opt.value);
    sel.selectedIndex = 0;
}

function removeLine(btn) { btn.closest('tr').remove(); calcTotals(); }

function calcLine(input) { calcTotals(); }

function calcTotals() {
    let subtotal = 0, tax = 0;
    document.querySelectorAll('.line-row').forEach(row => {
        const qty = parseFloat(row.querySelector('[name="line_quantity[]"]').value) || 0;
        const price = parseFloat(row.querySelector('[name="line_unit_price[]"]').value) || 0;
        const taxRate = parseFloat(row.querySelector('[name="line_tax_rate[]"]').value) || 0;
        const lineSub = qty * price;
        const lineTax = lineSub * taxRate / 100;
        subtotal += lineSub;
        tax += lineTax;
        row.querySelector('.line-total').textContent = formatEur(lineSub + lineTax);
    });
    document.getElementById('subtotal').textContent = formatEur(subtotal);
    document.getElementById('taxtotal').textContent = formatEur(tax);
    document.getElementById('grandtotal').textContent = formatEur(subtotal + tax);
}

function formatEur(n) { return '€ ' + n.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.'); }

document.addEventListener('DOMContentLoaded', calcTotals);
</script>
