<!-- Stats Grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="stat-card">
        <div class="flex items-center justify-between">
            <div>
                <div class="stat-label">Omzet deze maand</div>
                <div class="stat-value text-blue-600"><?= $this->formatMoney($mtd) ?></div>
            </div>
            <div class="w-12 h-12 rounded-xl bg-blue-50 flex items-center justify-center">
                <i class="fas fa-chart-line text-blue-500 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="stat-card">
        <div class="flex items-center justify-between">
            <div>
                <div class="stat-label">Openstaand (<?= (int)($outstanding['count'] ?? 0) ?>)</div>
                <div class="stat-value text-amber-600"><?= $this->formatMoney((float)($outstanding['total'] ?? 0)) ?></div>
            </div>
            <div class="w-12 h-12 rounded-xl bg-amber-50 flex items-center justify-center">
                <i class="fas fa-clock text-amber-500 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="stat-card">
        <div class="flex items-center justify-between">
            <div>
                <div class="stat-label">Verlopen (<?= (int)($overdue['count'] ?? 0) ?>)</div>
                <div class="stat-value text-red-600"><?= $this->formatMoney((float)($overdue['total'] ?? 0)) ?></div>
            </div>
            <div class="w-12 h-12 rounded-xl bg-red-50 flex items-center justify-center">
                <i class="fas fa-exclamation-triangle text-red-500 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="stat-card">
        <div class="flex items-center justify-between">
            <div>
                <div class="stat-label">Ontvangen deze maand</div>
                <div class="stat-value text-green-600"><?= $this->formatMoney($paidMonth) ?></div>
            </div>
            <div class="w-12 h-12 rounded-xl bg-green-50 flex items-center justify-center">
                <i class="fas fa-check-circle text-green-500 text-xl"></i>
            </div>
        </div>
    </div>
</div>

<!-- Aging + Quick Actions -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
    <!-- Aging Chart -->
    <div class="card p-6 lg:col-span-2">
        <h3 class="text-lg font-semibold mb-4 text-gray-800">Verouderingsanalyse (Aging)</h3>
        <div class="grid grid-cols-4 gap-4">
            <div class="text-center p-4 bg-green-50 rounded-lg">
                <div class="text-2xl font-bold text-green-700"><?= $this->formatMoney((float)($aging['d30'] ?? 0)) ?></div>
                <div class="text-sm text-green-600 mt-1">0-30 dagen</div>
            </div>
            <div class="text-center p-4 bg-yellow-50 rounded-lg">
                <div class="text-2xl font-bold text-yellow-700"><?= $this->formatMoney((float)($aging['d60'] ?? 0)) ?></div>
                <div class="text-sm text-yellow-600 mt-1">31-60 dagen</div>
            </div>
            <div class="text-center p-4 bg-orange-50 rounded-lg">
                <div class="text-2xl font-bold text-orange-700"><?= $this->formatMoney((float)($aging['d90'] ?? 0)) ?></div>
                <div class="text-sm text-orange-600 mt-1">61-90 dagen</div>
            </div>
            <div class="text-center p-4 bg-red-50 rounded-lg">
                <div class="text-2xl font-bold text-red-700"><?= $this->formatMoney((float)($aging['d90plus'] ?? 0)) ?></div>
                <div class="text-sm text-red-600 mt-1">90+ dagen</div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="card p-6">
        <h3 class="text-lg font-semibold mb-4 text-gray-800">Snelle acties</h3>
        <div class="space-y-3">
            <a href="/invoices/create" class="flex items-center gap-3 p-3 rounded-lg bg-blue-50 hover:bg-blue-100 text-blue-700 transition">
                <i class="fas fa-plus-circle"></i> Nieuwe factuur
            </a>
            <a href="/customers/create" class="flex items-center gap-3 p-3 rounded-lg bg-green-50 hover:bg-green-100 text-green-700 transition">
                <i class="fas fa-user-plus"></i> Nieuwe klant
            </a>
            <a href="/quotes/create" class="flex items-center gap-3 p-3 rounded-lg bg-purple-50 hover:bg-purple-100 text-purple-700 transition">
                <i class="fas fa-file-alt"></i> Nieuwe offerte
            </a>
            <a href="/reports" class="flex items-center gap-3 p-3 rounded-lg bg-gray-50 hover:bg-gray-100 text-gray-700 transition">
                <i class="fas fa-chart-bar"></i> Rapportages
            </a>
        </div>
    </div>
</div>

<!-- Recent Invoices -->
<div class="card">
    <div class="px-6 py-4 border-b flex items-center justify-between">
        <h3 class="text-lg font-semibold text-gray-800">Recente facturen</h3>
        <a href="/invoices" class="text-sm text-blue-600 hover:underline">Alles bekijken →</a>
    </div>
    <div class="overflow-x-auto">
        <table>
            <thead>
                <tr>
                    <th>Nummer</th>
                    <th>Klant</th>
                    <th>Datum</th>
                    <th>Vervaldatum</th>
                    <th class="text-right">Bedrag</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($recentInvoices)): ?>
                <tr><td colspan="6" class="text-center text-gray-400 py-8">Nog geen facturen</td></tr>
                <?php else: ?>
                <?php foreach ($recentInvoices as $inv): ?>
                <tr>
                    <td><a href="/invoices/<?= $inv['id'] ?>" class="text-blue-600 font-medium hover:underline"><?= htmlspecialchars($inv['invoice_number'] ?: 'CONCEPT') ?></a></td>
                    <td><?= htmlspecialchars($inv['customer_name'] ?? '-') ?></td>
                    <td><?= $inv['issue_date'] ? date('d-m-Y', strtotime($inv['issue_date'])) : '-' ?></td>
                    <td><?= $inv['due_date'] ? date('d-m-Y', strtotime($inv['due_date'])) : '-' ?></td>
                    <td class="text-right font-medium"><?= $this->formatMoney((float)$inv['total']) ?></td>
                    <td>
                        <?php
                        $statusMap = [
                            'draft' => ['Concept', 'badge-gray'],
                            'final' => ['Definitief', 'badge-blue'],
                            'sent' => ['Verzonden', 'badge-blue'],
                            'overdue' => ['Verlopen', 'badge-red'],
                            'partially_paid' => ['Deels betaald', 'badge-yellow'],
                            'paid' => ['Betaald', 'badge-green'],
                            'cancelled' => ['Geannuleerd', 'badge-gray'],
                        ];
                        $s = $statusMap[$inv['status']] ?? ['Onbekend', 'badge-gray'];
                        ?>
                        <span class="badge <?= $s[1] ?>"><?= $s[0] ?></span>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
