<div class="mb-6 flex items-center gap-3">
    <a href="/customers" class="text-gray-400 hover:text-gray-600"><i class="fas fa-arrow-left"></i></a>
    <h2 class="text-2xl font-bold"><?= htmlspecialchars($customer['company_name']) ?></h2>
    <?php if ($customer['archived_at']): ?><span class="badge badge-gray">Gearchiveerd</span><?php endif; ?>
    <div class="ml-auto flex gap-2">
        <a href="/invoices/create?customer_id=<?= $customer['id'] ?>" class="btn-primary btn-sm"><i class="fas fa-plus mr-1"></i>Factuur</a>
        <a href="/customers/<?= $customer['id'] ?>/edit" class="btn-secondary btn-sm"><i class="fas fa-edit mr-1"></i>Bewerken</a>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2">
        <!-- Stats -->
        <div class="grid grid-cols-3 gap-4 mb-6">
            <div class="stat-card"><div class="stat-label">Gefactureerd</div><div class="stat-value text-lg"><?= $this->formatMoney((float)($stats['total_invoiced'] ?? 0)) ?></div></div>
            <div class="stat-card"><div class="stat-label">Betaald</div><div class="stat-value text-lg text-green-600"><?= $this->formatMoney((float)($stats['total_paid'] ?? 0)) ?></div></div>
            <div class="stat-card"><div class="stat-label">Openstaand</div><div class="stat-value text-lg text-amber-600"><?= $this->formatMoney((float)($stats['total_due'] ?? 0)) ?></div></div>
        </div>

        <!-- Invoices -->
        <div class="card">
            <div class="px-6 py-4 border-b"><h3 class="font-semibold">Facturen</h3></div>
            <table>
                <thead><tr><th>Nummer</th><th>Datum</th><th class="text-right">Bedrag</th><th>Status</th></tr></thead>
                <tbody>
                <?php if (empty($invoices)): ?>
                    <tr><td colspan="4" class="text-center text-gray-400 py-6">Geen facturen</td></tr>
                <?php else: ?>
                    <?php foreach ($invoices as $inv): ?>
                    <tr>
                        <td><a href="/invoices/<?= $inv['id'] ?>" class="text-blue-600 hover:underline"><?= htmlspecialchars($inv['invoice_number'] ?: 'CONCEPT') ?></a></td>
                        <td><?= $inv['issue_date'] ? date('d-m-Y', strtotime($inv['issue_date'])) : '-' ?></td>
                        <td class="text-right font-medium"><?= $this->formatMoney((float)$inv['total']) ?></td>
                        <td><?php $sm = ['draft'=>['Concept','badge-gray'],'final'=>['Definitief','badge-blue'],'sent'=>['Verzonden','badge-blue'],'overdue'=>['Verlopen','badge-red'],'partially_paid'=>['Deels','badge-yellow'],'paid'=>['Betaald','badge-green'],'cancelled'=>['Geannuleerd','badge-gray']]; $s = $sm[$inv['status']] ?? ['?','badge-gray']; ?><span class="badge <?= $s[1] ?>"><?= $s[0] ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Sidebar -->
    <div>
        <div class="card p-6 mb-6">
            <h3 class="font-semibold mb-3">Gegevens</h3>
            <div class="space-y-3 text-sm">
                <?php if ($customer['address_line1']): ?><div><span class="text-gray-500">Adres</span><br><?= htmlspecialchars($customer['address_line1']) ?><br><?= htmlspecialchars($customer['postal_code'] . ' ' . $customer['city']) ?></div><?php endif; ?>
                <?php if ($customer['email']): ?><div><span class="text-gray-500">E-mail</span><br><a href="mailto:<?= htmlspecialchars($customer['email']) ?>" class="text-blue-600"><?= htmlspecialchars($customer['email']) ?></a></div><?php endif; ?>
                <?php if ($customer['phone']): ?><div><span class="text-gray-500">Telefoon</span><br><?= htmlspecialchars($customer['phone']) ?></div><?php endif; ?>
                <?php if ($customer['vat_number']): ?><div><span class="text-gray-500">BTW-nr</span><br><?= htmlspecialchars($customer['vat_number']) ?></div><?php endif; ?>
                <?php if ($customer['kvk_number']): ?><div><span class="text-gray-500">KVK-nr</span><br><?= htmlspecialchars($customer['kvk_number']) ?></div><?php endif; ?>
                <div><span class="text-gray-500">Betaaltermijn</span><br><?= $customer['payment_terms'] ?? 'Standaard' ?> dagen</div>
            </div>
        </div>

        <?php if (!empty($contacts)): ?>
        <div class="card p-6">
            <h3 class="font-semibold mb-3">Contactpersonen</h3>
            <div class="space-y-3">
                <?php foreach ($contacts as $c): ?>
                <div class="text-sm">
                    <div class="font-medium"><?= htmlspecialchars($c['name']) ?><?= $c['is_primary'] ? ' <span class="badge badge-blue text-xs">Primair</span>' : '' ?></div>
                    <?php if ($c['function_title']): ?><div class="text-gray-500"><?= htmlspecialchars($c['function_title']) ?></div><?php endif; ?>
                    <?php if ($c['email']): ?><div><a href="mailto:<?= htmlspecialchars($c['email']) ?>" class="text-blue-600"><?= htmlspecialchars($c['email']) ?></a></div><?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
