<div class="flex items-center justify-between mb-6">
    <div class="flex items-center gap-4">
        <form method="GET" action="/customers" class="flex items-center gap-2">
            <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Zoek klant..." class="form-input" style="width: 280px;">
            <button type="submit" class="btn-secondary btn-sm"><i class="fas fa-search"></i></button>
            <?php if ($search): ?>
                <a href="/customers" class="text-sm text-gray-500 hover:text-gray-700">Wissen</a>
            <?php endif; ?>
        </form>
        <label class="flex items-center gap-2 text-sm text-gray-600">
            <input type="checkbox" onchange="window.location='?archived=<?= $showArchived ? '0' : '1' ?><?= $search ? '&search='.urlencode($search) : '' ?>'" <?= $showArchived ? 'checked' : '' ?>>
            Gearchiveerd tonen
        </label>
    </div>
    <a href="/customers/create" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nieuwe klant</a>
</div>

<div class="card">
    <div class="overflow-x-auto">
        <table>
            <thead>
                <tr>
                    <th>Nr.</th>
                    <th>Bedrijfsnaam</th>
                    <th>Plaats</th>
                    <th>E-mail</th>
                    <th>Telefoon</th>
                    <th>Status</th>
                    <th class="text-right">Acties</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($customers)): ?>
                <tr><td colspan="7" class="text-center text-gray-400 py-8">
                    <?= $search ? 'Geen klanten gevonden' : 'Nog geen klanten' ?>
                </td></tr>
                <?php else: ?>
                <?php foreach ($customers as $c): ?>
                <tr class="<?= $c['archived_at'] ? 'opacity-50' : '' ?>">
                    <td class="text-gray-500 text-sm"><?= htmlspecialchars($c['customer_number'] ?? '-') ?></td>
                    <td>
                        <a href="/customers/<?= $c['id'] ?>" class="text-blue-600 font-medium hover:underline">
                            <?= htmlspecialchars($c['company_name']) ?>
                        </a>
                    </td>
                    <td><?= htmlspecialchars($c['city'] ?? '-') ?></td>
                    <td class="text-sm"><?= htmlspecialchars($c['email'] ?? '-') ?></td>
                    <td class="text-sm"><?= htmlspecialchars($c['phone'] ?? '-') ?></td>
                    <td>
                        <?php if ($c['archived_at']): ?>
                            <span class="badge badge-gray">Gearchiveerd</span>
                        <?php else: ?>
                            <span class="badge badge-green">Actief</span>
                        <?php endif; ?>
                    </td>
                    <td class="text-right">
                        <a href="/customers/<?= $c['id'] ?>/edit" class="text-gray-400 hover:text-blue-600 mr-2" title="Bewerken"><i class="fas fa-edit"></i></a>
                        <?php if ($c['archived_at']): ?>
                            <form method="POST" action="/customers/<?= $c['id'] ?>/restore" class="inline">
                                <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                                <button type="submit" class="text-gray-400 hover:text-green-600" title="Herstellen"><i class="fas fa-undo"></i></button>
                            </form>
                        <?php else: ?>
                            <form method="POST" action="/customers/<?= $c['id'] ?>/archive" class="inline" onsubmit="return confirm('Klant archiveren?')">
                                <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                                <button type="submit" class="text-gray-400 hover:text-red-600" title="Archiveren"><i class="fas fa-archive"></i></button>
                            </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if ($pagination['total_pages'] > 1): ?>
    <div class="px-6 py-4 border-t flex items-center justify-between">
        <span class="text-sm text-gray-500"><?= $pagination['total'] ?> klanten</span>
        <div class="flex gap-1">
            <?php for ($p = 1; $p <= $pagination['total_pages']; $p++): ?>
            <a href="?page=<?= $p ?>&search=<?= urlencode($search) ?>" 
               class="px-3 py-1 rounded text-sm <?= $p === $pagination['page'] ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' ?>">
                <?= $p ?>
            </a>
            <?php endfor; ?>
        </div>
    </div>
    <?php endif; ?>
</div>
