<?php $isEdit = !empty($customer); ?>
<form method="POST" action="<?= $isEdit ? "/customers/{$customer['id']}" : '/customers' ?>">
    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2">
            <div class="card p-6 mb-6">
                <h3 class="text-lg font-semibold mb-4">Bedrijfsgegevens</h3>
                <div class="grid grid-cols-2 gap-4">
                    <div class="col-span-2"><label class="form-label">Bedrijfsnaam *</label><input type="text" name="company_name" class="form-input" required value="<?= htmlspecialchars($customer['company_name'] ?? '') ?>"></div>
                    <div><label class="form-label">Klantnummer</label><input type="text" name="customer_number" class="form-input" value="<?= htmlspecialchars($customer['customer_number'] ?? '') ?>"></div>
                    <div><label class="form-label">KVK-nummer</label><input type="text" name="kvk_number" class="form-input" value="<?= htmlspecialchars($customer['kvk_number'] ?? '') ?>"></div>
                    <div><label class="form-label">BTW-nummer</label><input type="text" name="vat_number" class="form-input" value="<?= htmlspecialchars($customer['vat_number'] ?? '') ?>" placeholder="NL123456789B01"></div>
                    <div><label class="form-label">Website</label><input type="text" name="website" class="form-input" value="<?= htmlspecialchars($customer['website'] ?? '') ?>"></div>
                </div>
            </div>
            <div class="card p-6 mb-6">
                <h3 class="text-lg font-semibold mb-4">Adres</h3>
                <div class="grid grid-cols-2 gap-4">
                    <div class="col-span-2"><label class="form-label">Adresregel 1</label><input type="text" name="address_line1" class="form-input" value="<?= htmlspecialchars($customer['address_line1'] ?? '') ?>"></div>
                    <div class="col-span-2"><label class="form-label">Adresregel 2</label><input type="text" name="address_line2" class="form-input" value="<?= htmlspecialchars($customer['address_line2'] ?? '') ?>"></div>
                    <div><label class="form-label">Postcode</label><input type="text" name="postal_code" class="form-input" value="<?= htmlspecialchars($customer['postal_code'] ?? '') ?>"></div>
                    <div><label class="form-label">Plaats</label><input type="text" name="city" class="form-input" value="<?= htmlspecialchars($customer['city'] ?? '') ?>"></div>
                    <div><label class="form-label">Land</label>
                        <select name="country" class="form-input">
                            <option value="NL" <?= ($customer['country'] ?? 'NL') === 'NL' ? 'selected' : '' ?>>Nederland</option>
                            <option value="BE" <?= ($customer['country'] ?? '') === 'BE' ? 'selected' : '' ?>>België</option>
                            <option value="DE" <?= ($customer['country'] ?? '') === 'DE' ? 'selected' : '' ?>>Duitsland</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold">Contactpersonen</h3>
                    <button type="button" onclick="addContact()" class="btn-secondary btn-sm"><i class="fas fa-plus mr-1"></i> Toevoegen</button>
                </div>
                <div id="contacts-list">
                    <?php foreach ($contacts ?? [] as $i => $c): ?>
                    <div class="contact-row grid grid-cols-4 gap-3 mb-3 items-end">
                        <div><label class="form-label text-xs">Naam</label><input type="text" name="contact_name[]" class="form-input" value="<?= htmlspecialchars($c['name']) ?>"></div>
                        <div><label class="form-label text-xs">E-mail</label><input type="email" name="contact_email[]" class="form-input" value="<?= htmlspecialchars($c['email'] ?? '') ?>"></div>
                        <div><label class="form-label text-xs">Telefoon</label><input type="text" name="contact_phone[]" class="form-input" value="<?= htmlspecialchars($c['phone'] ?? '') ?>"></div>
                        <div class="flex items-end gap-2"><div class="flex-1"><label class="form-label text-xs">Functie</label><input type="text" name="contact_function[]" class="form-input" value="<?= htmlspecialchars($c['function_title'] ?? '') ?>"></div><button type="button" onclick="this.closest('.contact-row').remove()" class="text-red-400 hover:text-red-600 pb-2"><i class="fas fa-trash"></i></button></div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <div>
            <div class="card p-6 mb-6">
                <h3 class="text-lg font-semibold mb-4">Contact & Instellingen</h3>
                <div class="space-y-4">
                    <div><label class="form-label">E-mail</label><input type="email" name="email" class="form-input" value="<?= htmlspecialchars($customer['email'] ?? '') ?>"></div>
                    <div><label class="form-label">Telefoon</label><input type="text" name="phone" class="form-input" value="<?= htmlspecialchars($customer['phone'] ?? '') ?>"></div>
                    <div><label class="form-label">Betalingstermijn (dagen)</label><input type="number" name="payment_terms" class="form-input" value="<?= htmlspecialchars($customer['payment_terms'] ?? '') ?>" placeholder="Standaard organisatie"></div>
                    <div><label class="form-label">Valuta</label><select name="currency" class="form-input"><option value="EUR" <?= ($customer['currency'] ?? 'EUR') === 'EUR' ? 'selected' : '' ?>>EUR (€)</option><option value="USD" <?= ($customer['currency'] ?? '') === 'USD' ? 'selected' : '' ?>>USD ($)</option></select></div>
                    <div><label class="form-label">Taal</label><select name="language" class="form-input"><option value="nl" <?= ($customer['language'] ?? 'nl') === 'nl' ? 'selected' : '' ?>>Nederlands</option><option value="en" <?= ($customer['language'] ?? '') === 'en' ? 'selected' : '' ?>>Engels</option></select></div>
                </div>
            </div>
            <div class="card p-6 mb-6">
                <h3 class="text-lg font-semibold mb-4">Notities</h3>
                <textarea name="notes" class="form-input" rows="4"><?= htmlspecialchars($customer['notes'] ?? '') ?></textarea>
            </div>
            <div class="flex gap-3">
                <button type="submit" class="btn-primary flex-1"><i class="fas fa-save mr-2"></i><?= $isEdit ? 'Opslaan' : 'Aanmaken' ?></button>
                <a href="/customers" class="btn-secondary">Annuleren</a>
            </div>
        </div>
    </div>
</form>
<script>
function addContact() {
    const list = document.getElementById('contacts-list');
    const row = document.createElement('div');
    row.className = 'contact-row grid grid-cols-4 gap-3 mb-3 items-end';
    row.innerHTML = '<div><label class="form-label text-xs">Naam</label><input type="text" name="contact_name[]" class="form-input"></div><div><label class="form-label text-xs">E-mail</label><input type="email" name="contact_email[]" class="form-input"></div><div><label class="form-label text-xs">Telefoon</label><input type="text" name="contact_phone[]" class="form-input"></div><div class="flex items-end gap-2"><div class="flex-1"><label class="form-label text-xs">Functie</label><input type="text" name="contact_function[]" class="form-input"></div><button type="button" onclick="this.closest(\'.contact-row\').remove()" class="text-red-400 hover:text-red-600 pb-2"><i class="fas fa-trash"></i></button></div>';
    list.appendChild(row);
}
</script>
