<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-slate-900 via-blue-900 to-slate-900">
    <div class="w-full max-w-md">
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-blue-600 mb-4">
                <i class="fas fa-file-invoice text-white text-2xl"></i>
            </div>
            <h1 class="text-3xl font-bold text-white">Invoice App</h1>
            <p class="text-blue-200 mt-2">Facturatie & Beheer</p>
        </div>
        <div class="bg-white rounded-2xl shadow-2xl p-8">
            <?php if ($flash ?? null): ?>
            <div class="mb-4 p-3 rounded-lg text-sm <?= $flash['type'] === 'error' ? 'bg-red-50 text-red-700' : 'bg-green-50 text-green-700' ?>">
                <?= htmlspecialchars($flash['message']) ?>
            </div>
            <?php endif; ?>
            <form method="POST" action="/login">
                <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                <div class="mb-5">
                    <label class="form-label" for="email">E-mailadres</label>
                    <input type="email" name="email" id="email" class="form-input" required autofocus placeholder="admin@example.com">
                </div>
                <div class="mb-6">
                    <label class="form-label" for="password">Wachtwoord</label>
                    <input type="password" name="password" id="password" class="form-input" required placeholder="••••••••">
                </div>
                <button type="submit" class="btn-primary w-full py-3 text-center rounded-lg text-base">
                    <i class="fas fa-sign-in-alt mr-2"></i> Inloggen
                </button>
            </form>
        </div>
        <p class="text-center text-blue-300 text-sm mt-6">Standaard login: admin@example.com / admin123</p>
    </div>
</div>
