<?php
Auth::requirePermission('settings', 'edit');
$db = Database::get();

$id = (int)($_POST['id'] ?? 0);
$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$passwordConfirm = $_POST['password_confirm'] ?? '';
$roleId = (int)($_POST['role_id'] ?? 0);
$status = $_POST['status'] ?? 'active';
$resetLockout = isset($_POST['reset_lockout']);

// Check user exists
$stmt = $db->prepare('SELECT * FROM users WHERE id = ?');
$stmt->execute([$id]);
$before = $stmt->fetch();
if (!$before) { Flash::error('Gebruiker niet gevonden.'); redirect('/settings/users'); }

// Validation
$errors = [];
if (!$name) $errors[] = 'Naam is verplicht';
if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Geldig e-mailadres is verplicht';
if ($password && strlen($password) < 8) $errors[] = 'Wachtwoord moet minimaal 8 tekens zijn';
if ($password && $password !== $passwordConfirm) $errors[] = 'Wachtwoorden komen niet overeen';

// Check unique email (except self)
$stmt = $db->prepare('SELECT id FROM users WHERE email = ? AND id != ?');
$stmt->execute([$email, $id]);
if ($stmt->fetch()) $errors[] = 'Dit e-mailadres is al in gebruik';

if ($errors) {
    Flash::error(implode('. ', $errors));
    redirect("/settings/users/edit?id=$id");
}

// Build update
$fields = ['name = ?', 'email = ?', 'role_id = ?', 'status = ?'];
$params = [$name, $email, $roleId, $status];

if ($password) {
    $fields[] = 'password_hash = ?';
    $params[] = password_hash($password, PASSWORD_BCRYPT);
}

if ($resetLockout) {
    $fields[] = 'failed_login_attempts = 0';
    $fields[] = 'locked_until = NULL';
}

$params[] = $id;
$sql = 'UPDATE users SET ' . implode(', ', $fields) . ' WHERE id = ?';
$stmt = $db->prepare($sql);
$stmt->execute($params);

$after = ['name' => $name, 'email' => $email, 'role_id' => $roleId, 'status' => $status];
if ($password) $after['password'] = '***changed***';
if ($resetLockout) $after['lockout'] = 'reset';

AuditLog::log('user', $id, 'updated',
    ['name' => $before['name'], 'email' => $before['email'], 'role_id' => $before['role_id'], 'status' => $before['status']],
    $after
);

Flash::success("Gebruiker '$name' is bijgewerkt.");
redirect('/settings/users');
