<?php
Auth::requirePermission('settings', 'edit');
$db = Database::get();

$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$passwordConfirm = $_POST['password_confirm'] ?? '';
$roleId = (int)($_POST['role_id'] ?? 0);
$status = $_POST['status'] ?? 'active';

// Validation
$errors = [];
if (!$name) $errors[] = 'Naam is verplicht';
if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Geldig e-mailadres is verplicht';
if (strlen($password) < 8) $errors[] = 'Wachtwoord moet minimaal 8 tekens zijn';
if ($password !== $passwordConfirm) $errors[] = 'Wachtwoorden komen niet overeen';
if (!$roleId) $errors[] = 'Rol is verplicht';

// Check unique email
$stmt = $db->prepare('SELECT id FROM users WHERE email = ?');
$stmt->execute([$email]);
if ($stmt->fetch()) $errors[] = 'Dit e-mailadres is al in gebruik';

if ($errors) {
    setOldInput();
    Flash::error(implode('. ', $errors));
    redirect('/settings/users/create');
}

$stmt = $db->prepare(
    'INSERT INTO users (name, email, password_hash, role_id, status) VALUES (?, ?, ?, ?, ?)'
);
$stmt->execute([
    $name,
    $email,
    password_hash($password, PASSWORD_BCRYPT),
    $roleId,
    $status,
]);
$userId = $db->lastInsertId();

AuditLog::log('user', $userId, 'created', null, ['name' => $name, 'email' => $email, 'role_id' => $roleId, 'status' => $status]);
Flash::success("Gebruiker '$name' is aangemaakt.");
redirect('/settings/users');
