<?php
Auth::requirePermission('settings', 'edit');
$db = Database::get();
$id = (int)($_GET['id'] ?? 0);

$stmt = $db->prepare('SELECT * FROM users WHERE id = ?');
$stmt->execute([$id]);
$editUser = $stmt->fetch();
if (!$editUser) { Flash::error('Gebruiker niet gevonden.'); redirect('/settings/users'); }

$roles = $db->query('SELECT * FROM roles ORDER BY id')->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Gebruiker bewerken: <?= e($editUser['name']) ?></h5>
    <a href="/settings/users" class="btn btn-outline-secondary btn-sm">← Terug</a>
</div>
<div class="card">
    <div class="card-body">
        <form method="POST" action="/settings/users/update">
            <?= CSRF::field() ?>
            <input type="hidden" name="id" value="<?= $id ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Naam *</label>
                    <input type="text" name="name" class="form-control" required value="<?= e($editUser['name']) ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">E-mail *</label>
                    <input type="email" name="email" class="form-control" required value="<?= e($editUser['email']) ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Nieuw wachtwoord</label>
                    <input type="password" name="password" class="form-control" minlength="8">
                    <small class="text-muted">Laat leeg om niet te wijzigen</small>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Wachtwoord bevestigen</label>
                    <input type="password" name="password_confirm" class="form-control" minlength="8">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Rol *</label>
                    <select name="role_id" class="form-select" required>
                        <?php foreach ($roles as $r): ?>
                        <option value="<?= $r['id'] ?>" <?= $editUser['role_id'] == $r['id'] ? 'selected' : '' ?>><?= e($r['name']) ?> – <?= e($r['description'] ?? '') ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="active" <?= $editUser['status'] === 'active' ? 'selected' : '' ?>>Actief</option>
                        <option value="inactive" <?= $editUser['status'] === 'inactive' ? 'selected' : '' ?>>Inactief</option>
                        <option value="locked" <?= $editUser['status'] === 'locked' ? 'selected' : '' ?>>Geblokkeerd</option>
                    </select>
                </div>
            </div>
            <div class="mt-3 p-3 bg-light rounded small">
                <strong>Info:</strong> 
                Aangemaakt: <?= formatDate($editUser['created_at'], 'd-m-Y H:i') ?> · 
                Laatste login: <?= $editUser['last_login_at'] ? formatDate($editUser['last_login_at'], 'd-m-Y H:i') : 'Nooit' ?> · 
                Mislukte logins: <?= $editUser['failed_login_attempts'] ?>
                <?php if ($editUser['locked_until']): ?> · <span class="text-danger">Geblokkeerd tot: <?= formatDate($editUser['locked_until'], 'd-m-Y H:i') ?></span><?php endif; ?>
            </div>
            <div class="mt-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>Opslaan</button>
                <?php if ($editUser['failed_login_attempts'] > 0 || $editUser['locked_until']): ?>
                <button type="submit" name="reset_lockout" value="1" class="btn btn-outline-warning"><i class="bi bi-unlock me-1"></i>Reset lockout</button>
                <?php endif; ?>
            </div>
        </form>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Gebruiker bewerken', 'currentPage' => 'settings', 'content' => $content]);
