<?php
Auth::requirePermission('settings', 'edit');
$db = Database::get();
$roles = $db->query('SELECT * FROM roles ORDER BY id')->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Nieuwe gebruiker</h5>
    <a href="/settings/users" class="btn btn-outline-secondary btn-sm">← Terug</a>
</div>
<div class="card">
    <div class="card-body">
        <form method="POST" action="/settings/users/store">
            <?= CSRF::field() ?>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Naam *</label>
                    <input type="text" name="name" class="form-control" required value="<?= old('name') ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">E-mail *</label>
                    <input type="email" name="email" class="form-control" required value="<?= old('email') ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Wachtwoord *</label>
                    <input type="password" name="password" class="form-control" required minlength="8">
                    <small class="text-muted">Minimaal 8 tekens</small>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Wachtwoord bevestigen *</label>
                    <input type="password" name="password_confirm" class="form-control" required minlength="8">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Rol *</label>
                    <select name="role_id" class="form-select" required>
                        <?php foreach ($roles as $r): ?>
                        <option value="<?= $r['id'] ?>"><?= e($r['name']) ?> – <?= e($r['description'] ?? '') ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="active">Actief</option>
                        <option value="inactive">Inactief</option>
                    </select>
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="bi bi-person-plus me-1"></i>Aanmaken</button>
            </div>
        </form>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Nieuwe gebruiker', 'currentPage' => 'settings', 'content' => $content]);
