<?php
Auth::requirePermission('settings', 'edit');
$db = Database::get();

$stmt = $db->prepare(
    'SELECT u.*, r.name as role_name, r.slug as role_slug
     FROM users u JOIN roles r ON r.id = u.role_id
     ORDER BY u.name'
);
$stmt->execute();
$users = $stmt->fetchAll();

$roles = $db->query('SELECT * FROM roles ORDER BY id')->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-people me-2"></i>Gebruikers</h5>
    <div class="d-flex gap-2">
        <a href="/settings" class="btn btn-outline-secondary btn-sm">← Instellingen</a>
        <a href="/settings/users/create" class="btn btn-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Nieuwe gebruiker</a>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead><tr><th>Naam</th><th>E-mail</th><th>Rol</th><th>Status</th><th>Laatste login</th><th></th></tr></thead>
            <tbody>
            <?php foreach ($users as $u): ?>
            <tr>
                <td class="fw-medium"><?= e($u['name']) ?></td>
                <td><?= e($u['email']) ?></td>
                <td><span class="badge bg-<?= $u['role_slug'] === 'admin' ? 'danger' : ($u['role_slug'] === 'finance' ? 'success' : 'secondary') ?>"><?= e($u['role_name']) ?></span></td>
                <td><?= statusBadge($u['status']) ?></td>
                <td class="small text-muted"><?= $u['last_login_at'] ? formatDate($u['last_login_at'], 'd-m-Y H:i') : 'Nooit' ?></td>
                <td class="text-end">
                    <a href="/settings/users/edit?id=<?= $u['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                </td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Gebruikers', 'currentPage' => 'settings', 'content' => $content]);
