<?php
Auth::requirePermission('settings', 'edit');
$db = Database::get();

$settingsMap = [
    'company_name' => 'company', 'company_kvk' => 'company', 'company_vat' => 'company',
    'company_address' => 'company', 'company_postal' => 'company', 'company_city' => 'company',
    'company_iban' => 'company', 'company_bic' => 'company', 'company_phone' => 'company',
    'company_email' => 'company', 'company_website' => 'company',
    'invoice_prefix' => 'invoice', 'invoice_year_prefix' => 'invoice', 'invoice_number_padding' => 'invoice',
    'invoice_next_number' => 'invoice', 'default_payment_terms' => 'invoice',
    'default_currency' => 'invoice', 'default_language' => 'invoice',
    'smtp_host' => 'email', 'smtp_port' => 'email', 'smtp_user' => 'email', 'smtp_pass' => 'email',
    'smtp_from_name' => 'email', 'smtp_from_email' => 'email', 'smtp_encryption' => 'email',
    'reminder_r1_days' => 'reminders', 'reminder_r2_days' => 'reminders', 'reminder_r3_days' => 'reminders',
    'reminders_auto' => 'reminders',
];

$before = [];
$after = [];

$db->beginTransaction();
try {
    $stmt = $db->prepare('INSERT INTO settings (setting_key, setting_value, setting_group) VALUES (?, ?, ?)
        ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)');

    foreach ($settingsMap as $key => $group) {
        $value = trim($_POST[$key] ?? '');
        $before[$key] = Settings::get($key);
        $after[$key] = $value;
        $stmt->execute([$key, $value, $group]);
    }

    Settings::clearCache();
    AuditLog::log('settings', null, 'updated', $before, $after);
    $db->commit();
    Flash::success('Instellingen opgeslagen.');
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout: ' . $e->getMessage());
}

redirect('/settings');
