<?php
Auth::requirePermission('settings', 'view');
$db = Database::get();

// Load all settings grouped
$groups = ['company' => [], 'invoice' => [], 'email' => [], 'reminders' => [], 'general' => []];
$stmt = $db->query('SELECT * FROM settings ORDER BY setting_group, setting_key');
foreach ($stmt->fetchAll() as $s) {
    $groups[$s['setting_group']][$s['setting_key']] = $s['setting_value'];
}

// Tax codes
$taxCodes = $db->query('SELECT * FROM tax_codes ORDER BY rate DESC')->fetchAll();

// Flatten for easy access
$s = array_merge(...array_values($groups));

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-gear me-2"></i>Instellingen</h5>
    <div class="d-flex gap-2">
        <?php if (Auth::hasPermission('settings', 'manage_users')): ?>
        <a href="/settings/users" class="btn btn-outline-secondary btn-sm"><i class="bi bi-people me-1"></i>Gebruikers</a>
        <?php endif; ?>
    </div>
</div>

<form method="POST" action="/settings/update">
    <?= CSRF::field() ?>
    
    <!-- Company -->
    <div class="card mb-3">
        <div class="card-header"><i class="bi bi-building me-1"></i> Bedrijfsgegevens</div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Bedrijfsnaam *</label>
                    <input type="text" name="company_name" class="form-control" value="<?= e($s['company_name'] ?? '') ?>" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">KVK-nummer</label>
                    <input type="text" name="company_kvk" class="form-control" value="<?= e($s['company_kvk'] ?? '') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">BTW-nummer</label>
                    <input type="text" name="company_vat" class="form-control" value="<?= e($s['company_vat'] ?? '') ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Adres</label>
                    <input type="text" name="company_address" class="form-control" value="<?= e($s['company_address'] ?? '') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Postcode</label>
                    <input type="text" name="company_postal" class="form-control" value="<?= e($s['company_postal'] ?? '') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Plaats</label>
                    <input type="text" name="company_city" class="form-control" value="<?= e($s['company_city'] ?? '') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">IBAN</label>
                    <input type="text" name="company_iban" class="form-control" value="<?= e($s['company_iban'] ?? '') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">BIC</label>
                    <input type="text" name="company_bic" class="form-control" value="<?= e($s['company_bic'] ?? '') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Telefoon</label>
                    <input type="text" name="company_phone" class="form-control" value="<?= e($s['company_phone'] ?? '') ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">E-mailadres</label>
                    <input type="email" name="company_email" class="form-control" value="<?= e($s['company_email'] ?? '') ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Website</label>
                    <input type="text" name="company_website" class="form-control" value="<?= e($s['company_website'] ?? '') ?>">
                </div>
            </div>
        </div>
    </div>

    <!-- Invoice settings -->
    <div class="card mb-3">
        <div class="card-header"><i class="bi bi-receipt me-1"></i> Factuurnummering</div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Prefix</label>
                    <input type="text" name="invoice_prefix" class="form-control" value="<?= e($s['invoice_prefix'] ?? 'FAC') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Jaar in nummer</label>
                    <select name="invoice_year_prefix" class="form-select">
                        <option value="1" <?= ($s['invoice_year_prefix'] ?? '1') === '1' ? 'selected' : '' ?>>Ja (FAC-2026-0001)</option>
                        <option value="0" <?= ($s['invoice_year_prefix'] ?? '1') === '0' ? 'selected' : '' ?>>Nee (FAC-0001)</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Opvulling (cijfers)</label>
                    <input type="number" name="invoice_number_padding" class="form-control" min="2" max="8" value="<?= e($s['invoice_number_padding'] ?? '4') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Volgend nummer</label>
                    <input type="number" name="invoice_next_number" class="form-control" min="1" value="<?= e($s['invoice_next_number'] ?? '1') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Standaard betaaltermijn (dagen)</label>
                    <input type="number" name="default_payment_terms" class="form-control" min="0" value="<?= e($s['default_payment_terms'] ?? '30') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Standaard valuta</label>
                    <select name="default_currency" class="form-select">
                        <option value="EUR" <?= ($s['default_currency'] ?? 'EUR') === 'EUR' ? 'selected' : '' ?>>EUR (€)</option>
                        <option value="USD" <?= ($s['default_currency'] ?? '') === 'USD' ? 'selected' : '' ?>>USD ($)</option>
                        <option value="GBP" <?= ($s['default_currency'] ?? '') === 'GBP' ? 'selected' : '' ?>>GBP (£)</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Standaard taal</label>
                    <select name="default_language" class="form-select">
                        <option value="nl" <?= ($s['default_language'] ?? 'nl') === 'nl' ? 'selected' : '' ?>>Nederlands</option>
                        <option value="en" <?= ($s['default_language'] ?? '') === 'en' ? 'selected' : '' ?>>English</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Email settings -->
    <div class="card mb-3">
        <div class="card-header"><i class="bi bi-envelope me-1"></i> E-mail (SMTP)</div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">SMTP Host</label>
                    <input type="text" name="smtp_host" class="form-control" value="<?= e($s['smtp_host'] ?? '') ?>" placeholder="smtp.example.com">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Poort</label>
                    <input type="number" name="smtp_port" class="form-control" value="<?= e($s['smtp_port'] ?? '587') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Gebruikersnaam</label>
                    <input type="text" name="smtp_user" class="form-control" value="<?= e($s['smtp_user'] ?? '') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Wachtwoord</label>
                    <input type="password" name="smtp_pass" class="form-control" value="<?= e($s['smtp_pass'] ?? '') ?>" placeholder="••••••">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Afzendernaam</label>
                    <input type="text" name="smtp_from_name" class="form-control" value="<?= e($s['smtp_from_name'] ?? '') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Afzender e-mail</label>
                    <input type="email" name="smtp_from_email" class="form-control" value="<?= e($s['smtp_from_email'] ?? '') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Beveiliging</label>
                    <select name="smtp_encryption" class="form-select">
                        <option value="tls" <?= ($s['smtp_encryption'] ?? 'tls') === 'tls' ? 'selected' : '' ?>>TLS</option>
                        <option value="ssl" <?= ($s['smtp_encryption'] ?? '') === 'ssl' ? 'selected' : '' ?>>SSL</option>
                        <option value="" <?= empty($s['smtp_encryption']) ? 'selected' : '' ?>>Geen</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Reminder settings -->
    <div class="card mb-3">
        <div class="card-header"><i class="bi bi-bell me-1"></i> Herinneringen</div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Herinnering 1 na (dagen na vervaldatum)</label>
                    <input type="number" name="reminder_r1_days" class="form-control" min="1" value="<?= e($s['reminder_r1_days'] ?? '7') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Herinnering 2 na (dagen)</label>
                    <input type="number" name="reminder_r2_days" class="form-control" min="1" value="<?= e($s['reminder_r2_days'] ?? '14') ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Herinnering 3 na (dagen)</label>
                    <input type="number" name="reminder_r3_days" class="form-control" min="1" value="<?= e($s['reminder_r3_days'] ?? '28') ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Automatische herinneringen</label>
                    <select name="reminders_auto" class="form-select">
                        <option value="1" <?= ($s['reminders_auto'] ?? '0') === '1' ? 'selected' : '' ?>>Ingeschakeld</option>
                        <option value="0" <?= ($s['reminders_auto'] ?? '0') === '0' ? 'selected' : '' ?>>Uitgeschakeld (alleen handmatig)</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Tax codes -->
    <div class="card mb-3">
        <div class="card-header"><i class="bi bi-percent me-1"></i> BTW-tarieven</div>
        <div class="card-body p-0">
            <table class="table table-sm mb-0">
                <thead><tr><th>Code</th><th>Naam</th><th>Tarief</th><th>Standaard</th><th>Actief</th></tr></thead>
                <tbody>
                <?php foreach ($taxCodes as $tc): ?>
                <tr>
                    <td><code><?= e($tc['code']) ?></code></td>
                    <td><?= e($tc['name']) ?></td>
                    <td><?= number_format($tc['rate'], 1) ?>%</td>
                    <td><?= $tc['is_default'] ? '<i class="bi bi-check-circle text-success"></i>' : '' ?></td>
                    <td><?= $tc['active'] ? '<span class="badge bg-success">Actief</span>' : '<span class="badge bg-secondary">Inactief</span>' ?></td>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <div class="p-2"><small class="text-muted">BTW-tarieven kunnen direct in de database worden beheerd.</small></div>
        </div>
    </div>

    <div class="mb-4">
        <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>Instellingen opslaan</button>
    </div>
</form>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Instellingen', 'currentPage' => 'settings', 'content' => $content]);
