<?php
Auth::requirePermission('reports', 'view');
$db = Database::get();

$year = (int)($_GET['year'] ?? date('Y'));
$quarter = $_GET['quarter'] ?? '';

$whereDate = "YEAR(i.issue_date) = ?";
$params = [$year];
if ($quarter) {
    $qStart = ($quarter - 1) * 3 + 1;
    $qEnd = $qStart + 2;
    $whereDate .= " AND MONTH(i.issue_date) BETWEEN ? AND ?";
    $params[] = $qStart;
    $params[] = $qEnd;
}

// BTW by rate
$stmt = $db->prepare("SELECT dl.tax_rate, 
    SUM(dl.line_subtotal) as base_amount,
    SUM(dl.line_tax) as tax_amount,
    SUM(dl.line_total) as total_amount,
    COUNT(DISTINCT i.id) as invoice_count
    FROM document_lines dl
    JOIN invoices i ON dl.document_id = i.id AND dl.document_type = 'invoice'
    WHERE i.status NOT IN ('draft','cancelled') AND $whereDate
    GROUP BY dl.tax_rate ORDER BY dl.tax_rate DESC");
$stmt->execute($params);
$vatLines = $stmt->fetchAll();

$totalBase = array_sum(array_column($vatLines, 'base_amount'));
$totalTax = array_sum(array_column($vatLines, 'tax_amount'));
$totalAll = array_sum(array_column($vatLines, 'total_amount'));

// Per quarter summary
$stmt = $db->prepare("SELECT QUARTER(i.issue_date) as q,
    SUM(dl.line_subtotal) as base_amount, SUM(dl.line_tax) as tax_amount
    FROM document_lines dl
    JOIN invoices i ON dl.document_id = i.id AND dl.document_type = 'invoice'
    WHERE i.status NOT IN ('draft','cancelled') AND YEAR(i.issue_date) = ?
    GROUP BY QUARTER(i.issue_date) ORDER BY q");
$stmt->execute([$year]);
$quarterly = $stmt->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-receipt me-2"></i>BTW-rapport</h5>
    <div class="d-flex gap-2">
        <a href="/reports/export?type=vat&year=<?= $year ?>&quarter=<?= $quarter ?>" class="btn btn-outline-secondary btn-sm"><i class="bi bi-download me-1"></i>Export CSV</a>
        <a href="/reports" class="btn btn-outline-secondary btn-sm">Terug</a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body py-2">
        <form method="GET" class="d-flex gap-3 align-items-center">
            <select name="year" class="form-select form-select-sm" style="width:auto">
                <?php for ($y = date('Y'); $y >= date('Y') - 5; $y--): ?>
                <option value="<?= $y ?>" <?= $y == $year ? 'selected' : '' ?>><?= $y ?></option>
                <?php endfor; ?>
            </select>
            <select name="quarter" class="form-select form-select-sm" style="width:auto">
                <option value="">Heel jaar</option>
                <option value="1" <?= $quarter == '1' ? 'selected' : '' ?>>Q1 (jan-mrt)</option>
                <option value="2" <?= $quarter == '2' ? 'selected' : '' ?>>Q2 (apr-jun)</option>
                <option value="3" <?= $quarter == '3' ? 'selected' : '' ?>>Q3 (jul-sep)</option>
                <option value="4" <?= $quarter == '4' ? 'selected' : '' ?>>Q4 (okt-dec)</option>
            </select>
            <button class="btn btn-primary btn-sm">Filter</button>
        </form>
    </div>
</div>

<!-- BTW per tarief -->
<div class="card mb-3">
    <div class="card-header">BTW per tarief<?= $quarter ? " — Q$quarter $year" : " — $year" ?></div>
    <div class="table-responsive">
        <table class="table table-sm mb-0">
            <thead><tr><th>BTW-tarief</th><th class="text-end">Grondslag (excl. BTW)</th><th class="text-end">BTW bedrag</th><th class="text-end">Totaal (incl. BTW)</th><th class="text-end">Facturen</th></tr></thead>
            <tbody>
            <?php if (empty($vatLines)): ?>
            <tr><td colspan="5" class="text-center text-muted py-3">Geen data</td></tr>
            <?php else: foreach ($vatLines as $v): ?>
            <tr>
                <td><span class="badge bg-secondary"><?= number_format($v['tax_rate'], 1) ?>%</span></td>
                <td class="text-end"><?= formatMoney($v['base_amount']) ?></td>
                <td class="text-end fw-semibold"><?= formatMoney($v['tax_amount']) ?></td>
                <td class="text-end"><?= formatMoney($v['total_amount']) ?></td>
                <td class="text-end"><?= $v['invoice_count'] ?></td>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
            <tfoot>
                <tr class="fw-bold">
                    <td>Totaal</td>
                    <td class="text-end"><?= formatMoney($totalBase) ?></td>
                    <td class="text-end"><?= formatMoney($totalTax) ?></td>
                    <td class="text-end"><?= formatMoney($totalAll) ?></td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<!-- Quarterly summary -->
<div class="card">
    <div class="card-header">Kwartaaloverzicht <?= $year ?></div>
    <div class="table-responsive">
        <table class="table table-sm mb-0">
            <thead><tr><th>Kwartaal</th><th class="text-end">Grondslag</th><th class="text-end">Af te dragen BTW</th></tr></thead>
            <tbody>
            <?php $totBase = 0; $totTax = 0; foreach ($quarterly as $q): $totBase += $q['base_amount']; $totTax += $q['tax_amount']; ?>
            <tr<?= $quarter == $q['q'] ? ' class="table-active"' : '' ?>>
                <td><a href="?year=<?= $year ?>&quarter=<?= $q['q'] ?>">Q<?= $q['q'] ?></a></td>
                <td class="text-end"><?= formatMoney($q['base_amount']) ?></td>
                <td class="text-end fw-semibold"><?= formatMoney($q['tax_amount']) ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
            <tfoot><tr class="fw-bold"><td>Totaal</td><td class="text-end"><?= formatMoney($totBase) ?></td><td class="text-end"><?= formatMoney($totTax) ?></td></tr></tfoot>
        </table>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'BTW-rapport', 'currentPage' => 'reports', 'content' => $content]);
