<?php
Auth::requirePermission('reports', 'view');
$db = Database::get();

$year = (int)($_GET['year'] ?? date('Y'));
$month = $_GET['month'] ?? '';
$groupBy = $_GET['group'] ?? 'month';

// Revenue by month for the year
$stmt = $db->prepare("SELECT MONTH(issue_date) as m, 
    SUM(subtotal) as subtotal, SUM(tax_total) as tax, SUM(total) as total, COUNT(*) as cnt
    FROM invoices WHERE status IN ('paid','partially_paid','sent','overdue') AND YEAR(issue_date) = ?
    GROUP BY MONTH(issue_date) ORDER BY m");
$stmt->execute([$year]);
$monthly = $stmt->fetchAll();
$monthMap = [];
foreach ($monthly as $r) $monthMap[$r['m']] = $r;

// Revenue by customer
$stmt = $db->prepare("SELECT c.name as customer_name, c.id as customer_id,
    SUM(i.total) as total, SUM(i.subtotal) as subtotal, COUNT(*) as cnt
    FROM invoices i JOIN customers c ON c.id = i.customer_id
    WHERE i.status IN ('paid','partially_paid','sent','overdue') AND YEAR(i.issue_date) = ?
    " . ($month ? "AND MONTH(i.issue_date) = ?" : "") . "
    GROUP BY c.id ORDER BY total DESC");
$params = [$year];
if ($month) $params[] = (int)$month;
$stmt->execute($params);
$byCustomer = $stmt->fetchAll();

// Totals
$yearTotal = array_sum(array_column($byCustomer, 'total'));
$yearSubtotal = array_sum(array_column($byCustomer, 'subtotal'));

$months = ['', 'Januari', 'Februari', 'Maart', 'April', 'Mei', 'Juni', 'Juli', 'Augustus', 'September', 'Oktober', 'November', 'December'];

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-graph-up me-2"></i>Omzetrapport</h5>
    <div class="d-flex gap-2">
        <a href="/reports/export?type=revenue&year=<?= $year ?>&month=<?= $month ?>" class="btn btn-outline-secondary btn-sm"><i class="bi bi-download me-1"></i>Export CSV</a>
        <a href="/reports" class="btn btn-outline-secondary btn-sm">Terug</a>
    </div>
</div>

<!-- Filters -->
<div class="card mb-3">
    <div class="card-body py-2">
        <form method="GET" class="d-flex gap-3 align-items-center">
            <div>
                <select name="year" class="form-select form-select-sm">
                    <?php for ($y = date('Y'); $y >= date('Y') - 5; $y--): ?>
                    <option value="<?= $y ?>" <?= $y == $year ? 'selected' : '' ?>><?= $y ?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <div>
                <select name="month" class="form-select form-select-sm">
                    <option value="">Heel jaar</option>
                    <?php for ($m = 1; $m <= 12; $m++): ?>
                    <option value="<?= $m ?>" <?= $month == $m ? 'selected' : '' ?>><?= $months[$m] ?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <button class="btn btn-primary btn-sm">Filter</button>
        </form>
    </div>
</div>

<!-- Monthly overview -->
<div class="card mb-3">
    <div class="card-header">Omzet per maand — <?= $year ?></div>
    <div class="table-responsive">
        <table class="table table-sm mb-0">
            <thead><tr><th>Maand</th><th class="text-end">Facturen</th><th class="text-end">Subtotaal</th><th class="text-end">BTW</th><th class="text-end">Totaal</th></tr></thead>
            <tbody>
            <?php 
            $grandTotal = 0; $grandSub = 0; $grandTax = 0; $grandCnt = 0;
            for ($m = 1; $m <= 12; $m++): 
                $r = $monthMap[$m] ?? ['cnt' => 0, 'subtotal' => 0, 'tax' => 0, 'total' => 0];
                $grandTotal += $r['total']; $grandSub += $r['subtotal']; $grandTax += $r['tax']; $grandCnt += $r['cnt'];
            ?>
            <tr <?= $month == $m ? 'class="table-active"' : '' ?>>
                <td><a href="?year=<?= $year ?>&month=<?= $m ?>"><?= $months[$m] ?></a></td>
                <td class="text-end"><?= $r['cnt'] ?></td>
                <td class="text-end"><?= formatMoney($r['subtotal']) ?></td>
                <td class="text-end"><?= formatMoney($r['tax']) ?></td>
                <td class="text-end fw-semibold"><?= formatMoney($r['total']) ?></td>
            </tr>
            <?php endfor; ?>
            </tbody>
            <tfoot>
                <tr class="fw-bold"><td>Totaal <?= $year ?></td><td class="text-end"><?= $grandCnt ?></td><td class="text-end"><?= formatMoney($grandSub) ?></td><td class="text-end"><?= formatMoney($grandTax) ?></td><td class="text-end"><?= formatMoney($grandTotal) ?></td></tr>
            </tfoot>
        </table>
    </div>
</div>

<!-- By customer -->
<div class="card">
    <div class="card-header">Omzet per klant<?= $month ? ' — ' . $months[(int)$month] . ' ' . $year : ' — ' . $year ?></div>
    <div class="table-responsive">
        <table class="table table-sm mb-0">
            <thead><tr><th>Klant</th><th class="text-end">Facturen</th><th class="text-end">Subtotaal</th><th class="text-end">Totaal</th><th class="text-end">Aandeel</th></tr></thead>
            <tbody>
            <?php if (empty($byCustomer)): ?>
            <tr><td colspan="5" class="text-center text-muted py-3">Geen data beschikbaar</td></tr>
            <?php else: foreach ($byCustomer as $c): ?>
            <tr>
                <td><a href="/customers/view?id=<?= $c['customer_id'] ?>"><?= e($c['customer_name']) ?></a></td>
                <td class="text-end"><?= $c['cnt'] ?></td>
                <td class="text-end"><?= formatMoney($c['subtotal']) ?></td>
                <td class="text-end fw-semibold"><?= formatMoney($c['total']) ?></td>
                <td class="text-end"><?= $yearTotal > 0 ? round($c['total'] / $yearTotal * 100, 1) : 0 ?>%</td>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Omzetrapport', 'currentPage' => 'reports', 'content' => $content]);
