<?php
Auth::requirePermission('reports', 'view');
$db = Database::get();

$stmt = $db->prepare("SELECT i.*, c.name as customer_name, c.email as customer_email,
    DATEDIFF(CURDATE(), i.due_date) as days_overdue
    FROM invoices i JOIN customers c ON c.id = i.customer_id
    WHERE i.status IN ('sent','overdue','partially_paid') AND i.amount_due > 0
    ORDER BY i.due_date ASC");
$stmt->execute();
$invoices = $stmt->fetchAll();

$totalDue = array_sum(array_column($invoices, 'amount_due'));
$overdueCount = count(array_filter($invoices, fn($i) => $i['days_overdue'] > 0));
$overdueDue = array_sum(array_map(fn($i) => $i['days_overdue'] > 0 ? $i['amount_due'] : 0, $invoices));

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-file-earmark-text me-2"></i>Openstaande facturen</h5>
    <div class="d-flex gap-2">
        <a href="/reports/export?type=outstanding" class="btn btn-outline-secondary btn-sm"><i class="bi bi-download me-1"></i>Export CSV</a>
        <a href="/reports" class="btn btn-outline-secondary btn-sm">Terug</a>
    </div>
</div>

<div class="row g-3 mb-3">
    <div class="col-md-4">
        <div class="stat-card">
            <div class="stat-label">Totaal openstaand</div>
            <div class="stat-value"><?= formatMoney($totalDue) ?></div>
            <small class="text-muted"><?= count($invoices) ?> facturen</small>
        </div>
    </div>
    <div class="col-md-4">
        <div class="stat-card">
            <div class="stat-label">Waarvan te laat</div>
            <div class="stat-value text-danger"><?= formatMoney($overdueDue) ?></div>
            <small class="text-muted"><?= $overdueCount ?> facturen</small>
        </div>
    </div>
    <div class="col-md-4">
        <div class="stat-card">
            <div class="stat-label">Nog niet vervallen</div>
            <div class="stat-value text-success"><?= formatMoney($totalDue - $overdueDue) ?></div>
            <small class="text-muted"><?= count($invoices) - $overdueCount ?> facturen</small>
        </div>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-sm table-hover mb-0">
            <thead><tr><th>Factuurnr</th><th>Klant</th><th>Datum</th><th>Vervaldatum</th><th class="text-end">Totaal</th><th class="text-end">Openstaand</th><th>Status</th><th>Dagen</th></tr></thead>
            <tbody>
            <?php if (empty($invoices)): ?>
            <tr><td colspan="8" class="text-center text-muted py-4">Geen openstaande facturen 🎉</td></tr>
            <?php else: foreach ($invoices as $i): ?>
            <tr class="<?= $i['days_overdue'] > 60 ? 'table-danger' : ($i['days_overdue'] > 0 ? 'table-warning' : '') ?>">
                <td><a href="/invoices/view?id=<?= $i['id'] ?>"><?= e($i['invoice_number']) ?></a></td>
                <td><?= e($i['customer_name']) ?></td>
                <td><?= formatDate($i['issue_date']) ?></td>
                <td><?= formatDate($i['due_date']) ?></td>
                <td class="text-end"><?= formatMoney($i['total']) ?></td>
                <td class="text-end fw-semibold"><?= formatMoney($i['amount_due']) ?></td>
                <td><?= statusBadge($i['status']) ?></td>
                <td>
                    <?php if ($i['days_overdue'] > 0): ?>
                    <span class="text-danger"><?= $i['days_overdue'] ?>d te laat</span>
                    <?php else: ?>
                    <span class="text-muted"><?= abs($i['days_overdue']) ?>d</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Openstaande facturen', 'currentPage' => 'reports', 'content' => $content]);
