<?php
Auth::requirePermission('reports', 'view');
$db = Database::get();

// Quick stats
$stmt = $db->query("SELECT 
    COALESCE(SUM(CASE WHEN status = 'paid' AND YEAR(issue_date) = YEAR(CURDATE()) THEN total END), 0) as revenue_ytd,
    COALESCE(SUM(CASE WHEN status = 'paid' AND MONTH(issue_date) = MONTH(CURDATE()) AND YEAR(issue_date) = YEAR(CURDATE()) THEN total END), 0) as revenue_mtd,
    COALESCE(SUM(CASE WHEN status IN ('sent','overdue','partially_paid') THEN amount_due END), 0) as total_outstanding,
    COALESCE(SUM(CASE WHEN status = 'overdue' THEN amount_due END), 0) as total_overdue,
    COUNT(CASE WHEN status IN ('sent','overdue','partially_paid') THEN 1 END) as open_count,
    COUNT(CASE WHEN status = 'overdue' THEN 1 END) as overdue_count
    FROM invoices");
$stats = $stmt->fetch();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Rapportages</h5>
</div>

<!-- Quick Stats -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between">
                <div><div class="stat-label">Omzet YTD</div><div class="stat-value"><?= formatMoney($stats['revenue_ytd']) ?></div></div>
                <div class="stat-icon bg-success bg-opacity-10 text-success"><i class="bi bi-graph-up-arrow"></i></div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between">
                <div><div class="stat-label">Omzet MTD</div><div class="stat-value"><?= formatMoney($stats['revenue_mtd']) ?></div></div>
                <div class="stat-icon bg-primary bg-opacity-10 text-primary"><i class="bi bi-calendar-check"></i></div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between">
                <div><div class="stat-label">Openstaand (<?= $stats['open_count'] ?>)</div><div class="stat-value"><?= formatMoney($stats['total_outstanding']) ?></div></div>
                <div class="stat-icon bg-warning bg-opacity-10 text-warning"><i class="bi bi-clock-history"></i></div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between">
                <div><div class="stat-label">Te laat (<?= $stats['overdue_count'] ?>)</div><div class="stat-value"><?= formatMoney($stats['total_overdue']) ?></div></div>
                <div class="stat-icon bg-danger bg-opacity-10 text-danger"><i class="bi bi-exclamation-triangle"></i></div>
            </div>
        </div>
    </div>
</div>

<!-- Report Links -->
<div class="row g-3">
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-body">
                <h6><i class="bi bi-graph-up me-2 text-primary"></i>Omzetrapport</h6>
                <p class="text-muted small">Omzet per klant, per product en per periode. Inclusief vergelijking en trends.</p>
                <a href="/reports/revenue" class="btn btn-outline-primary btn-sm">Bekijken</a>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-body">
                <h6><i class="bi bi-receipt me-2 text-success"></i>BTW-rapport</h6>
                <p class="text-muted small">BTW-overzicht per tarief per periode, voor belastingaangifte.</p>
                <a href="/reports/vat" class="btn btn-outline-success btn-sm">Bekijken</a>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-body">
                <h6><i class="bi bi-file-earmark-text me-2 text-warning"></i>Openstaande facturen</h6>
                <p class="text-muted small">Overzicht van alle openstaande en te late facturen met klantdetails.</p>
                <a href="/reports/outstanding" class="btn btn-outline-warning btn-sm">Bekijken</a>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-body">
                <h6><i class="bi bi-bar-chart me-2 text-danger"></i>Verouderingsanalyse</h6>
                <p class="text-muted small">Aging analyse: 0-30, 31-60, 61-90, 90+ dagen openstaand.</p>
                <a href="/reports/aging" class="btn btn-outline-danger btn-sm">Bekijken</a>
            </div>
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Rapportages', 'currentPage' => 'reports', 'content' => $content]);
