<?php
Auth::requirePermission('reports', 'view');
$db = Database::get();

$type = $_GET['type'] ?? '';
$year = (int)($_GET['year'] ?? date('Y'));
$month = $_GET['month'] ?? '';
$quarter = $_GET['quarter'] ?? '';

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="rapport-' . $type . '-' . date('Y-m-d') . '.csv"');

$out = fopen('php://output', 'w');
// BOM for Excel
fwrite($out, "\xEF\xBB\xBF");

switch ($type) {
    case 'revenue':
        fputcsv($out, ['Klant', 'Aantal facturen', 'Subtotaal', 'Totaal'], ';');
        $stmt = $db->prepare("SELECT c.name, COUNT(*) as cnt, SUM(i.subtotal) as sub, SUM(i.total) as tot
            FROM invoices i JOIN customers c ON c.id = i.customer_id
            WHERE i.status NOT IN ('draft','cancelled') AND YEAR(i.issue_date) = ?
            " . ($month ? "AND MONTH(i.issue_date) = ?" : "") . "
            GROUP BY c.id ORDER BY tot DESC");
        $params = [$year];
        if ($month) $params[] = (int)$month;
        $stmt->execute($params);
        foreach ($stmt->fetchAll() as $r) {
            fputcsv($out, [$r['name'], $r['cnt'], number_format($r['sub'], 2, ',', ''), number_format($r['tot'], 2, ',', '')], ';');
        }
        break;

    case 'vat':
        fputcsv($out, ['BTW-tarief', 'Grondslag', 'BTW bedrag', 'Totaal', 'Facturen'], ';');
        $whereDate = "YEAR(i.issue_date) = ?";
        $params = [$year];
        if ($quarter) {
            $qStart = ($quarter - 1) * 3 + 1;
            $whereDate .= " AND MONTH(i.issue_date) BETWEEN ? AND ?";
            $params[] = $qStart;
            $params[] = $qStart + 2;
        }
        $stmt = $db->prepare("SELECT dl.tax_rate, SUM(dl.line_subtotal) as base, SUM(dl.line_tax) as tax, SUM(dl.line_total) as tot, COUNT(DISTINCT i.id) as cnt
            FROM document_lines dl JOIN invoices i ON dl.document_id = i.id AND dl.document_type = 'invoice'
            WHERE i.status NOT IN ('draft','cancelled') AND $whereDate
            GROUP BY dl.tax_rate ORDER BY dl.tax_rate DESC");
        $stmt->execute($params);
        foreach ($stmt->fetchAll() as $r) {
            fputcsv($out, [$r['tax_rate'] . '%', number_format($r['base'], 2, ',', ''), number_format($r['tax'], 2, ',', ''), number_format($r['tot'], 2, ',', ''), $r['cnt']], ';');
        }
        break;

    case 'outstanding':
        fputcsv($out, ['Factuurnummer', 'Klant', 'Factuurdatum', 'Vervaldatum', 'Totaal', 'Openstaand', 'Dagen te laat', 'Status'], ';');
        $stmt = $db->prepare("SELECT i.*, c.name as customer_name, DATEDIFF(CURDATE(), i.due_date) as days_overdue
            FROM invoices i JOIN customers c ON c.id = i.customer_id
            WHERE i.status IN ('sent','overdue','partially_paid') AND i.amount_due > 0
            ORDER BY i.due_date ASC");
        $stmt->execute();
        foreach ($stmt->fetchAll() as $i) {
            fputcsv($out, [
                $i['invoice_number'], $i['customer_name'], $i['issue_date'], $i['due_date'],
                number_format($i['total'], 2, ',', ''), number_format($i['amount_due'], 2, ',', ''),
                max(0, $i['days_overdue']), $i['status']
            ], ';');
        }
        break;

    case 'aging':
        fputcsv($out, ['Klant', 'Niet vervallen', '1-30 dagen', '31-60 dagen', '61-90 dagen', '90+ dagen', 'Totaal'], ';');
        $stmt = $db->prepare("SELECT i.*, c.name as customer_name, c.id as cid, DATEDIFF(CURDATE(), i.due_date) as days_overdue
            FROM invoices i JOIN customers c ON c.id = i.customer_id
            WHERE i.status IN ('sent','overdue','partially_paid') AND i.amount_due > 0");
        $stmt->execute();
        $aging = [];
        foreach ($stmt->fetchAll() as $i) {
            $cid = $i['cid'];
            if (!isset($aging[$cid])) $aging[$cid] = ['name' => $i['customer_name'], 'current' => 0, 'b30' => 0, 'b60' => 0, 'b90' => 0, 'b90plus' => 0, 'total' => 0];
            $d = $i['days_overdue'];
            $amt = (float)$i['amount_due'];
            $bucket = $d <= 0 ? 'current' : ($d <= 30 ? 'b30' : ($d <= 60 ? 'b60' : ($d <= 90 ? 'b90' : 'b90plus')));
            $aging[$cid][$bucket] += $amt;
            $aging[$cid]['total'] += $amt;
        }
        foreach ($aging as $a) {
            fputcsv($out, [$a['name'], number_format($a['current'], 2, ',', ''), number_format($a['b30'], 2, ',', ''), number_format($a['b60'], 2, ',', ''), number_format($a['b90'], 2, ',', ''), number_format($a['b90plus'], 2, ',', ''), number_format($a['total'], 2, ',', '')], ';');
        }
        break;

    default:
        fputcsv($out, ['Onbekend rapporttype'], ';');
}

fclose($out);
exit;
