<?php
Auth::requirePermission('reminders', 'send');
$db = Database::get();

$invoiceId = (int)($_POST['invoice_id'] ?? 0);
$stage = $_POST['stage'] ?? 'R1';
if (!in_array($stage, ['R1','R2','R3'])) $stage = 'R1';

// Get invoice + customer
$stmt = $db->prepare('SELECT i.*, c.name as customer_name, c.email as customer_email, c.language
    FROM invoices i JOIN customers c ON c.id = i.customer_id WHERE i.id = ?');
$stmt->execute([$invoiceId]);
$inv = $stmt->fetch();

if (!$inv) { Flash::error('Factuur niet gevonden.'); redirect('/reminders'); }
if (!$inv['customer_email']) { Flash::error('Geen e-mailadres voor deze klant.'); redirect('/reminders'); }

// Get template
$lang = $inv['language'] ?? 'nl';
$stmt = $db->prepare('SELECT * FROM reminder_templates WHERE stage = ? AND language = ?');
$stmt->execute([$stage, $lang]);
$template = $stmt->fetch();
if (!$template) {
    $stmt = $db->prepare('SELECT * FROM reminder_templates WHERE stage = ? AND language = ?');
    $stmt->execute([$stage, 'nl']);
    $template = $stmt->fetch();
}

$templateId = $template ? $template['id'] : null;

// Replace placeholders
$placeholders = [
    '{{customer_name}}' => $inv['customer_name'],
    '{{invoice_number}}' => $inv['invoice_number'],
    '{{due_date}}' => formatDate($inv['due_date']),
    '{{amount_due}}' => formatMoney($inv['amount_due'], $inv['currency']),
    '{{total}}' => formatMoney($inv['total'], $inv['currency']),
    '{{issue_date}}' => formatDate($inv['issue_date']),
    '{{company_name}}' => Settings::get('company_name', ''),
    '{{payment_link}}' => '#',
];
$subject = $template ? strtr($template['subject'], $placeholders) : "Herinnering factuur {$inv['invoice_number']}";
$body = $template ? strtr($template['body'], $placeholders) : "Betreft factuur {$inv['invoice_number']}";

// Register reminder in database
$stmt = $db->prepare(
    'INSERT INTO reminders (invoice_id, stage, template_id, sent_to, status, sent_at) VALUES (?, ?, ?, ?, ?, NOW())'
);

try {
    // Try to send email
    $smtpHost = Settings::get('smtp_host', '');
    $emailSent = false;

    if ($smtpHost) {
        // SMTP configured: attempt to send via PHP mail or custom mailer
        $from = Settings::get('smtp_from_email', Settings::get('company_email', 'noreply@example.com'));
        $fromName = Settings::get('smtp_from_name', Settings::get('company_name', 'InvoiceApp'));
        $headers = "From: $fromName <$from>\r\n";
        $headers .= "Reply-To: $from\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $emailSent = @mail($inv['customer_email'], $subject, $body, $headers);
    }

    $status = $emailSent ? 'sent' : 'pending';
    $stmt->execute([$invoiceId, $stage, $templateId, $inv['customer_email'], $status]);
    $reminderId = $db->lastInsertId();

    // Log in email_log
    $stmt2 = $db->prepare(
        'INSERT INTO email_log (entity_type, entity_id, recipient, subject, body, status, sent_at) VALUES (?, ?, ?, ?, ?, ?, NOW())'
    );
    $stmt2->execute(['reminder', $reminderId, $inv['customer_email'], $subject, $body, $status]);

    // Update invoice status to overdue if it was 'sent'
    if ($inv['status'] === 'sent') {
        $db->prepare('UPDATE invoices SET status = ? WHERE id = ?')->execute(['overdue', $invoiceId]);
    }

    AuditLog::log('reminder', $reminderId, 'sent', null, [
        'invoice_id' => $invoiceId, 'stage' => $stage, 'recipient' => $inv['customer_email'], 'status' => $status
    ]);

    if ($emailSent) {
        Flash::success("Herinnering $stage verstuurd naar {$inv['customer_email']}.");
    } else if ($smtpHost) {
        Flash::warning("Herinnering $stage geregistreerd maar e-mail versturen mislukt. Controleer SMTP-instellingen.");
    } else {
        Flash::info("Herinnering $stage geregistreerd. Configureer SMTP in Instellingen om e-mails automatisch te versturen.");
    }
} catch (\Exception $e) {
    $stmt->execute([$invoiceId, $stage, $templateId, $inv['customer_email'], 'failed']);
    $reminderId = $db->lastInsertId();
    $db->prepare('UPDATE reminders SET error_message = ? WHERE id = ?')->execute([$e->getMessage(), $reminderId]);
    Flash::error("Fout bij versturen herinnering: " . $e->getMessage());
}

redirect('/reminders');
