<?php
Auth::requirePermission('reminders', 'send');
$db = Database::get();
$invoiceId = (int)($_GET['invoice_id'] ?? 0);
$stage = $_GET['stage'] ?? 'R1';
if (!in_array($stage, ['R1','R2','R3'])) $stage = 'R1';

// Get invoice + customer
$stmt = $db->prepare('SELECT i.*, c.name as customer_name, c.email as customer_email, c.language
    FROM invoices i JOIN customers c ON c.id = i.customer_id WHERE i.id = ?');
$stmt->execute([$invoiceId]);
$inv = $stmt->fetch();
if (!$inv) { Flash::error('Factuur niet gevonden.'); redirect('/reminders'); }

// Get template
$lang = $inv['language'] ?? 'nl';
$stmt = $db->prepare('SELECT * FROM reminder_templates WHERE stage = ? AND language = ?');
$stmt->execute([$stage, $lang]);
$template = $stmt->fetch();
if (!$template) {
    // Fallback to NL
    $stmt = $db->prepare('SELECT * FROM reminder_templates WHERE stage = ? AND language = ?');
    $stmt->execute([$stage, 'nl']);
    $template = $stmt->fetch();
}

// Replace placeholders
$placeholders = [
    '{{customer_name}}' => $inv['customer_name'],
    '{{invoice_number}}' => $inv['invoice_number'],
    '{{due_date}}' => formatDate($inv['due_date']),
    '{{amount_due}}' => formatMoney($inv['amount_due'], $inv['currency']),
    '{{total}}' => formatMoney($inv['total'], $inv['currency']),
    '{{issue_date}}' => formatDate($inv['issue_date']),
    '{{company_name}}' => Settings::get('company_name', ''),
    '{{payment_link}}' => '#',
];
$subject = $template ? strtr($template['subject'], $placeholders) : "Herinnering factuur {$inv['invoice_number']}";
$body = $template ? strtr($template['body'], $placeholders) : "Betreft factuur {$inv['invoice_number']} - openstaand bedrag: " . formatMoney($inv['amount_due']);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-eye me-2"></i>Herinnering Preview – <?= e($stage) ?></h5>
    <a href="/reminders" class="btn btn-outline-secondary btn-sm">← Terug</a>
</div>

<div class="row g-3">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">E-mail preview</div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label text-muted small">Aan:</label>
                    <div class="fw-medium"><?= e($inv['customer_name']) ?> &lt;<?= e($inv['customer_email'] ?: 'geen e-mail ingesteld') ?>&gt;</div>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted small">Onderwerp:</label>
                    <div class="fw-medium"><?= e($subject) ?></div>
                </div>
                <hr>
                <div class="p-3 bg-light rounded" style="white-space:pre-wrap;font-size:.9rem"><?= e($body) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">Factuurgegevens</div>
            <div class="card-body small">
                <p><strong>Factuurnummer:</strong> <?= e($inv['invoice_number']) ?></p>
                <p><strong>Vervaldatum:</strong> <?= formatDate($inv['due_date']) ?></p>
                <p><strong>Openstaand:</strong> <span class="text-danger fw-bold"><?= formatMoney($inv['amount_due'], $inv['currency']) ?></span></p>
                <p><strong>Dagen te laat:</strong> <?= max(0, (int)((time() - strtotime($inv['due_date'])) / 86400)) ?></p>
                <p><strong>Status:</strong> <?= statusBadge($inv['status']) ?></p>
            </div>
        </div>
        <div class="card mt-3">
            <div class="card-body">
                <?php if (!$inv['customer_email']): ?>
                <div class="alert alert-danger small mb-3">
                    <i class="bi bi-exclamation-triangle me-1"></i>Geen e-mailadres ingesteld voor deze klant!
                </div>
                <?php endif; ?>
                <form method="POST" action="/reminders/send" onsubmit="return confirm('Herinnering <?= $stage ?> versturen naar <?= e($inv['customer_name']) ?>?')">
                    <?= CSRF::field() ?>
                    <input type="hidden" name="invoice_id" value="<?= $invoiceId ?>">
                    <input type="hidden" name="stage" value="<?= e($stage) ?>">
                    <button type="submit" class="btn btn-warning w-100" <?= !$inv['customer_email'] ? 'disabled' : '' ?>>
                        <i class="bi bi-send me-1"></i>Herinnering <?= e($stage) ?> versturen
                    </button>
                </form>
                <div class="text-center mt-2">
                    <small class="text-muted">Dit registreert de herinnering en stuurt een e-mail.</small>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Herinnering Preview', 'currentPage' => 'reminders', 'content' => $content]);
