<?php
Auth::requirePermission('reminders', 'view');
$db = Database::get();
$page = max(1, (int)($_GET['page'] ?? 1));

// Get reminder settings
$r1Days = (int)Settings::get('reminder_r1_days', 7);
$r2Days = (int)Settings::get('reminder_r2_days', 14);
$r3Days = (int)Settings::get('reminder_r3_days', 28);

// Overdue invoices with reminder status
$query = "SELECT i.id, i.invoice_number, i.due_date, i.total, i.amount_due, i.currency, i.status,
                 c.name as customer_name, c.email as customer_email,
                 DATEDIFF(CURDATE(), i.due_date) as days_overdue,
                 (SELECT MAX(r.stage) FROM reminders r WHERE r.invoice_id = i.id AND r.status = 'sent') as last_reminder,
                 (SELECT MAX(r.sent_at) FROM reminders r WHERE r.invoice_id = i.id AND r.status = 'sent') as last_reminder_date
          FROM invoices i
          JOIN customers c ON c.id = i.customer_id
          WHERE i.status IN ('sent','overdue','partially_paid') AND i.due_date < CURDATE() AND i.amount_due > 0
          ORDER BY i.due_date ASC";
$result = paginate($query, [], $page, 25);

// Stats
$stmt = $db->query("SELECT 
    COUNT(*) as total_overdue,
    COALESCE(SUM(amount_due), 0) as total_amount,
    COUNT(CASE WHEN DATEDIFF(CURDATE(), due_date) <= 7 THEN 1 END) as overdue_7,
    COUNT(CASE WHEN DATEDIFF(CURDATE(), due_date) BETWEEN 8 AND 14 THEN 1 END) as overdue_14,
    COUNT(CASE WHEN DATEDIFF(CURDATE(), due_date) BETWEEN 15 AND 30 THEN 1 END) as overdue_30,
    COUNT(CASE WHEN DATEDIFF(CURDATE(), due_date) > 30 THEN 1 END) as overdue_30plus
    FROM invoices WHERE status IN ('sent','overdue','partially_paid') AND due_date < CURDATE() AND amount_due > 0");
$stats = $stmt->fetch();

// Recent reminders sent
$stmt = $db->prepare("SELECT r.*, i.invoice_number, c.name as customer_name
    FROM reminders r JOIN invoices i ON i.id = r.invoice_id JOIN customers c ON c.id = i.customer_id
    ORDER BY r.created_at DESC LIMIT 10");
$stmt->execute();
$recentReminders = $stmt->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-bell me-2"></i>Herinneringen</h5>
</div>

<!-- Stats -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Vervallen facturen</div>
            <div class="stat-value"><?= $stats['total_overdue'] ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Openstaand bedrag</div>
            <div class="stat-value"><?= formatMoney($stats['total_amount']) ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">≤ 7 dagen</div>
            <div class="stat-value text-warning"><?= $stats['overdue_7'] ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">> 30 dagen</div>
            <div class="stat-value text-danger"><?= $stats['overdue_30plus'] ?></div>
        </div>
    </div>
</div>

<!-- Reminder policy info -->
<div class="alert alert-info small mb-3">
    <i class="bi bi-info-circle me-1"></i>
    <strong>Herinnering policy:</strong> R1 na <?= $r1Days ?> dagen · R2 na <?= $r2Days ?> dagen · R3 na <?= $r3Days ?> dagen.
    Aanpasbaar via <a href="/settings">Instellingen</a>.
</div>

<div class="row g-3">
    <div class="col-md-8">
        <!-- Overdue invoices -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span>Vervallen facturen</span>
            </div>
            <div class="table-responsive">
                <table class="table table-hover table-sm mb-0">
                    <thead><tr><th>Factuur</th><th>Klant</th><th>Vervaldatum</th><th>Dagen te laat</th><th>Openstaand</th><th>Laatste herinnering</th><th></th></tr></thead>
                    <tbody>
                    <?php if (empty($result['items'])): ?>
                    <tr><td colspan="7" class="text-center text-muted py-4"><i class="bi bi-check-circle me-1"></i>Geen vervallen facturen!</td></tr>
                    <?php else: foreach ($result['items'] as $inv): ?>
                    <tr>
                        <td><a href="/invoices/view?id=<?= $inv['id'] ?>"><?= e($inv['invoice_number']) ?></a></td>
                        <td><?= e($inv['customer_name']) ?></td>
                        <td><?= formatDate($inv['due_date']) ?></td>
                        <td>
                            <span class="badge bg-<?= $inv['days_overdue'] > 30 ? 'danger' : ($inv['days_overdue'] > 14 ? 'warning text-dark' : 'secondary') ?>">
                                <?= $inv['days_overdue'] ?> dagen
                            </span>
                        </td>
                        <td class="fw-semibold"><?= formatMoney($inv['amount_due'], $inv['currency']) ?></td>
                        <td>
                            <?php if ($inv['last_reminder']): ?>
                            <span class="badge bg-info"><?= e($inv['last_reminder']) ?></span>
                            <small class="text-muted ms-1"><?= formatDate($inv['last_reminder_date'], 'd-m') ?></small>
                            <?php else: ?>
                            <span class="text-muted small">Geen</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-end">
                            <?php if (Auth::hasPermission('reminders', 'send')): ?>
                            <?php
                            // Determine next stage
                            $nextStage = 'R1';
                            if ($inv['last_reminder'] === 'R1') $nextStage = 'R2';
                            elseif ($inv['last_reminder'] === 'R2') $nextStage = 'R3';
                            elseif ($inv['last_reminder'] === 'R3') $nextStage = 'R3';
                            ?>
                            <a href="/reminders/preview?invoice_id=<?= $inv['id'] ?>&stage=<?= $nextStage ?>" class="btn btn-sm btn-outline-warning" title="Preview herinnering">
                                <i class="bi bi-eye me-1"></i><?= $nextStage ?>
                            </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if ($result['total_pages'] > 1): ?>
            <div class="card-footer">
                <nav><ul class="pagination pagination-sm mb-0 justify-content-center">
                    <?php for ($i = 1; $i <= $result['total_pages']; $i++): ?>
                    <li class="page-item <?= $i === $result['page'] ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                    </li>
                    <?php endfor; ?>
                </ul></nav>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="col-md-4">
        <!-- Recent reminders -->
        <div class="card">
            <div class="card-header">Recente herinneringen</div>
            <div class="card-body p-0">
                <?php if (empty($recentReminders)): ?>
                <p class="text-muted small p-3 mb-0">Nog geen herinneringen verstuurd.</p>
                <?php else: ?>
                <div class="list-group list-group-flush">
                <?php foreach ($recentReminders as $r): ?>
                    <div class="list-group-item py-2">
                        <div class="d-flex justify-content-between">
                            <div>
                                <span class="badge bg-<?= $r['status'] === 'sent' ? 'success' : ($r['status'] === 'failed' ? 'danger' : 'secondary') ?> me-1"><?= e($r['stage']) ?></span>
                                <a href="/invoices/view?id=<?= $r['invoice_id'] ?>" class="small"><?= e($r['invoice_number']) ?></a>
                            </div>
                            <?= statusBadge($r['status']) ?>
                        </div>
                        <small class="text-muted"><?= e($r['customer_name']) ?> · <?= formatDate($r['created_at'], 'd-m-Y H:i') ?></small>
                    </div>
                <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Herinneringen', 'currentPage' => 'reminders', 'content' => $content]);
