<?php
Auth::requirePermission('payments', 'create');
$db = Database::get();

$invoiceId = (int)($_POST['invoice_id'] ?? 0);
$amount = round((float)($_POST['amount'] ?? 0), 2);
$paidAt = $_POST['paid_at'] ?? date('Y-m-d');
$method = $_POST['method'] ?? 'bank_transfer';
$reference = trim($_POST['reference'] ?? '');
$notes = trim($_POST['notes'] ?? '');

// Validate invoice
$stmt = $db->prepare("SELECT * FROM invoices WHERE id = ? AND status NOT IN ('draft','cancelled')");
$stmt->execute([$invoiceId]);
$invoice = $stmt->fetch();

if (!$invoice) {
    Flash::error('Factuur niet gevonden of niet beschikbaar voor betaling.');
    redirect('/payments/create');
}

if ($amount <= 0) {
    Flash::error('Bedrag moet groter zijn dan 0.');
    redirect('/payments/create?invoice_id=' . $invoiceId);
}

if ($amount > $invoice['amount_due'] + 0.01) {
    Flash::error('Bedrag overschrijdt het openstaande bedrag (' . formatMoney($invoice['amount_due']) . ').');
    redirect('/payments/create?invoice_id=' . $invoiceId);
}

$db->beginTransaction();
try {
    // Insert payment
    $stmt = $db->prepare('INSERT INTO payments (invoice_id, paid_at, amount, method, reference, notes, source, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?)');
    $stmt->execute([$invoiceId, $paidAt, $amount, $method, $reference ?: null, $notes ?: null, 'manual', Auth::userId()]);
    $paymentId = $db->lastInsertId();

    // Recalculate invoice totals
    $stmt = $db->prepare('SELECT COALESCE(SUM(amount), 0) FROM payments WHERE invoice_id = ?');
    $stmt->execute([$invoiceId]);
    $totalPaid = (float)$stmt->fetchColumn();

    $amountDue = max(0, $invoice['total'] - $totalPaid);
    $newStatus = $invoice['status'];
    if ($amountDue <= 0.01) {
        $newStatus = 'paid';
        $amountDue = 0;
    } elseif ($totalPaid > 0) {
        $newStatus = 'partially_paid';
    }

    $stmt = $db->prepare('UPDATE invoices SET amount_paid = ?, amount_due = ?, status = ?, updated_at = NOW() WHERE id = ?');
    $stmt->execute([$totalPaid, $amountDue, $newStatus, $invoiceId]);

    AuditLog::log('payment', $paymentId, 'created', null, [
        'invoice_id' => $invoiceId,
        'amount' => $amount,
        'method' => $method,
        'new_status' => $newStatus,
    ]);

    $db->commit();
    Flash::success('Betaling van ' . formatMoney($amount) . ' succesvol geregistreerd.');
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout bij registreren betaling: ' . $e->getMessage());
}

redirect('/invoices/view?id=' . $invoiceId);
