<?php
Auth::requirePermission('payments', 'view');
$db = Database::get();
$page = max(1, (int)($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');

$where = '1=1';
$params = [];
if ($search) {
    $where .= ' AND (i.invoice_number LIKE ? OR c.name LIKE ? OR p.reference LIKE ?)';
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

$query = "SELECT p.*, i.invoice_number, c.name as customer_name, i.currency 
          FROM payments p 
          JOIN invoices i ON i.id = p.invoice_id 
          JOIN customers c ON c.id = i.customer_id 
          WHERE $where ORDER BY p.paid_at DESC, p.created_at DESC";
$result = paginate($query, $params, $page);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Betalingen</h5>
    <?php if (Auth::hasPermission('payments', 'create')): ?>
    <a href="/payments/create" class="btn btn-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Betaling registreren</a>
    <?php endif; ?>
</div>
<div class="card">
    <div class="card-header">
        <form method="GET" class="d-flex gap-2">
            <input type="text" name="search" class="form-control form-control-sm" placeholder="Zoek op factuurnummer, klant of referentie..." value="<?= e($search) ?>" style="max-width:300px">
            <button class="btn btn-sm btn-outline-secondary">Zoeken</button>
        </form>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead><tr><th>Datum</th><th>Factuur</th><th>Klant</th><th>Bedrag</th><th>Methode</th><th>Referentie</th><th>Bron</th><th></th></tr></thead>
            <tbody>
            <?php if (empty($result['items'])): ?>
            <tr><td colspan="8" class="text-center text-muted py-4">Geen betalingen gevonden</td></tr>
            <?php else: foreach ($result['items'] as $p): ?>
            <tr>
                <td><?= formatDate($p['paid_at']) ?></td>
                <td><a href="/invoices/view?id=<?= $p['invoice_id'] ?>"><?= e($p['invoice_number'] ?: '-') ?></a></td>
                <td><?= e($p['customer_name']) ?></td>
                <td class="text-success fw-semibold"><?= formatMoney($p['amount'], $p['currency']) ?></td>
                <td><?= e(ucfirst(str_replace('_', ' ', $p['method']))) ?></td>
                <td><?= e($p['reference'] ?? '-') ?></td>
                <td><span class="badge <?= $p['source'] === 'psp' ? 'bg-info' : 'bg-secondary' ?>"><?= e($p['source']) ?></span></td>
                <td class="text-end">
                    <?php if (Auth::hasPermission('payments', 'delete')): ?>
                    <form method="POST" action="/payments/delete" class="d-inline" onsubmit="return confirm('Betaling verwijderen?')">
                        <?= CSRF::field() ?><input type="hidden" name="id" value="<?= $p['id'] ?>">
                        <button class="btn btn-sm btn-outline-danger"><i class="bi bi-trash"></i></button>
                    </form>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
    <?php if ($result['total_pages'] > 1): ?>
    <div class="card-footer">
        <nav><ul class="pagination pagination-sm mb-0 justify-content-center">
            <?php for ($i = 1; $i <= $result['total_pages']; $i++): ?>
            <li class="page-item <?= $i === $result['page'] ? 'active' : '' ?>">
                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
            </li>
            <?php endfor; ?>
        </ul></nav>
    </div>
    <?php endif; ?>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Betalingen', 'currentPage' => 'payments', 'content' => $content]);
