<?php
Auth::requirePermission('payments', 'delete');
$db = Database::get();
$id = (int)($_POST['id'] ?? 0);

$stmt = $db->prepare('SELECT p.*, i.total as invoice_total, i.status as invoice_status FROM payments p JOIN invoices i ON i.id = p.invoice_id WHERE p.id = ?');
$stmt->execute([$id]);
$payment = $stmt->fetch();

if (!$payment) {
    Flash::error('Betaling niet gevonden.');
    redirect('/payments');
}

$invoiceId = $payment['invoice_id'];

$db->beginTransaction();
try {
    $db->prepare('DELETE FROM payments WHERE id = ?')->execute([$id]);

    // Recalculate invoice
    $stmt = $db->prepare('SELECT COALESCE(SUM(amount), 0) FROM payments WHERE invoice_id = ?');
    $stmt->execute([$invoiceId]);
    $totalPaid = (float)$stmt->fetchColumn();
    $amountDue = max(0, $payment['invoice_total'] - $totalPaid);

    $newStatus = $payment['invoice_status'];
    if ($totalPaid <= 0) {
        $newStatus = in_array($payment['invoice_status'], ['paid', 'partially_paid']) ? 'sent' : $payment['invoice_status'];
    } elseif ($amountDue <= 0.01) {
        $newStatus = 'paid';
        $amountDue = 0;
    } else {
        $newStatus = 'partially_paid';
    }

    $db->prepare('UPDATE invoices SET amount_paid = ?, amount_due = ?, status = ?, updated_at = NOW() WHERE id = ?')
       ->execute([$totalPaid, $amountDue, $newStatus, $invoiceId]);

    AuditLog::log('payment', $id, 'deleted', $payment, null);
    $db->commit();
    Flash::success('Betaling verwijderd.');
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout bij verwijderen: ' . $e->getMessage());
}

redirect('/invoices/view?id=' . $invoiceId);
