<?php
Auth::requirePermission('payments', 'create');
$db = Database::get();
$invoiceId = (int)($_GET['invoice_id'] ?? 0);

// If specific invoice
$invoice = null;
if ($invoiceId) {
    $stmt = $db->prepare('SELECT i.*, c.name as customer_name FROM invoices i JOIN customers c ON c.id = i.customer_id WHERE i.id = ? AND i.status NOT IN (?, ?)');
    $stmt->execute([$invoiceId, 'draft', 'cancelled']);
    $invoice = $stmt->fetch();
}

// Get open invoices for dropdown
$stmt = $db->prepare("SELECT i.id, i.invoice_number, i.total, i.amount_due, i.currency, c.name as customer_name 
    FROM invoices i JOIN customers c ON c.id = i.customer_id 
    WHERE i.status IN ('final','sent','overdue','partially_paid') AND i.amount_due > 0 
    ORDER BY i.invoice_number DESC");
$stmt->execute();
$openInvoices = $stmt->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Betaling registreren</h5>
    <a href="<?= $invoiceId ? "/invoices/view?id=$invoiceId" : '/payments' ?>" class="btn btn-outline-secondary btn-sm">Terug</a>
</div>
<div class="card">
    <div class="card-body">
        <form method="POST" action="/payments/store">
            <?= CSRF::field() ?>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Factuur *</label>
                    <select name="invoice_id" class="form-select" required id="invoiceSelect">
                        <option value="">Selecteer factuur...</option>
                        <?php foreach ($openInvoices as $oi): ?>
                        <option value="<?= $oi['id'] ?>" data-due="<?= $oi['amount_due'] ?>" <?= $invoiceId == $oi['id'] ? 'selected' : '' ?>>
                            <?= e($oi['invoice_number']) ?> - <?= e($oi['customer_name']) ?> (openstaand: <?= formatMoney($oi['amount_due'], $oi['currency']) ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Bedrag *</label>
                    <div class="input-group">
                        <span class="input-group-text">€</span>
                        <input type="number" name="amount" class="form-control" step="0.01" min="0.01" required 
                            value="<?= $invoice ? $invoice['amount_due'] : '' ?>" id="amountField">
                    </div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Datum *</label>
                    <input type="date" name="paid_at" class="form-control" value="<?= date('Y-m-d') ?>" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Betaalmethode</label>
                    <select name="method" class="form-select">
                        <option value="bank_transfer">Bankoverschrijving</option>
                        <option value="ideal">iDEAL</option>
                        <option value="card">Creditcard</option>
                        <option value="cash">Contant</option>
                        <option value="other">Overig</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Referentie</label>
                    <input type="text" name="reference" class="form-control" placeholder="Bijv. transactiekenmerk">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Notities</label>
                    <input type="text" name="notes" class="form-control" placeholder="Optioneel">
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-success"><i class="bi bi-cash me-1"></i>Betaling registreren</button>
            </div>
        </form>
    </div>
</div>
<script>
document.getElementById('invoiceSelect')?.addEventListener('change', function() {
    const opt = this.options[this.selectedIndex];
    if (opt.dataset.due) document.getElementById('amountField').value = opt.dataset.due;
});
</script>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Betaling registreren', 'currentPage' => 'payments', 'content' => $content]);
