<?php
Auth::requirePermission('items', 'view');
$db = Database::get();
$page = max(1, (int)($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');

$where = 'i.active = 1';
$params = [];
if ($search) {
    $where .= ' AND (i.description LIKE ? OR i.sku LIKE ?)';
    $params = ["%$search%", "%$search%"];
}

$query = "SELECT i.*, tc.name as tax_name, tc.rate as tax_rate FROM items i LEFT JOIN tax_codes tc ON tc.id = i.tax_code_id WHERE $where ORDER BY i.description";
$result = paginate($query, $params, $page);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Producten & Diensten</h5>
    <?php if (Auth::hasPermission('items', 'create')): ?>
    <a href="/items/create" class="btn btn-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Nieuw product</a>
    <?php endif; ?>
</div>
<div class="card">
    <div class="card-header">
        <form method="GET" class="d-flex gap-2">
            <input type="text" name="search" class="form-control form-control-sm" placeholder="Zoeken..." value="<?= e($search) ?>" style="max-width:300px">
            <button class="btn btn-sm btn-outline-secondary">Zoeken</button>
        </form>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead><tr><th>SKU</th><th>Omschrijving</th><th>Eenheid</th><th>Prijs</th><th>BTW</th><th></th></tr></thead>
            <tbody>
            <?php if (empty($result['items'])): ?>
            <tr><td colspan="6" class="text-center text-muted py-4">Geen producten gevonden</td></tr>
            <?php else: foreach ($result['items'] as $item): ?>
            <tr>
                <td><?= e($item['sku'] ?: '-') ?></td>
                <td><?= e($item['description']) ?></td>
                <td><?= e($item['unit']) ?></td>
                <td><?= formatMoney($item['unit_price']) ?></td>
                <td><?= e($item['tax_name'] ?? '-') ?> (<?= $item['tax_rate'] ?? 0 ?>%)</td>
                <td class="text-end">
                    <a href="/items/edit?id=<?= $item['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                </td>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Producten & Diensten', 'currentPage' => 'items', 'content' => $content]);
