<?php
Auth::requirePermission('invoices', 'view');
$db = Database::get();
$id = (int)($_GET['id'] ?? 0);

$stmt = $db->prepare('SELECT i.*, c.name as customer_name, c.company_name, c.email as customer_email, c.billing_street, c.billing_city, c.billing_postal_code, c.billing_country, c.vat_number as customer_vat FROM invoices i JOIN customers c ON c.id = i.customer_id WHERE i.id = ?');
$stmt->execute([$id]);
$inv = $stmt->fetch();
if (!$inv) { Flash::error('Factuur niet gevonden.'); redirect('/invoices'); }

$stmt = $db->prepare("SELECT * FROM document_lines WHERE document_type = 'invoice' AND document_id = ? ORDER BY sort_order");
$stmt->execute([$id]);
$lines = $stmt->fetchAll();

$stmt = $db->prepare('SELECT * FROM payments WHERE invoice_id = ? ORDER BY paid_at DESC');
$stmt->execute([$id]);
$payments = $stmt->fetchAll();

$stmt = $db->prepare('SELECT * FROM reminders WHERE invoice_id = ? ORDER BY created_at DESC');
$stmt->execute([$id]);
$reminders = $stmt->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
    <div>
        <h5 class="mb-0">
            Factuur <?= e($inv['invoice_number'] ?: 'Concept') ?>
            <?= statusBadge($inv['status']) ?>
        </h5>
    </div>
    <div class="d-flex gap-2 flex-wrap">
        <?php if ($inv['status'] === 'draft'): ?>
            <a href="/invoices/edit?id=<?= $id ?>" class="btn btn-outline-secondary btn-sm"><i class="bi bi-pencil me-1"></i>Bewerken</a>
            <?php if (Auth::hasPermission('invoices', 'finalize')): ?>
            <form method="POST" action="/invoices/finalize" onsubmit="return confirm('Factuur definitief maken? Dit kan niet ongedaan worden.')">
                <?= CSRF::field() ?><input type="hidden" name="id" value="<?= $id ?>">
                <button class="btn btn-primary btn-sm"><i class="bi bi-lock me-1"></i>Definitief maken</button>
            </form>
            <?php endif; ?>
        <?php endif; ?>
        <?php if (in_array($inv['status'], ['final','sent','overdue','partially_paid'])): ?>
            <?php if (Auth::hasPermission('invoices', 'send')): ?>
            <form method="POST" action="/invoices/send">
                <?= CSRF::field() ?><input type="hidden" name="id" value="<?= $id ?>">
                <button class="btn btn-primary btn-sm"><i class="bi bi-envelope me-1"></i>Versturen</button>
            </form>
            <?php endif; ?>
            <?php if (Auth::hasPermission('payments', 'create')): ?>
            <a href="/payments/create?invoice_id=<?= $id ?>" class="btn btn-success btn-sm"><i class="bi bi-cash me-1"></i>Betaling</a>
            <?php endif; ?>
            <?php if (Auth::hasPermission('credits', 'create')): ?>
            <a href="/credits/create?invoice_id=<?= $id ?>" class="btn btn-outline-warning btn-sm"><i class="bi bi-file-earmark-minus me-1"></i>Creditnota</a>
            <?php endif; ?>
        <?php endif; ?>
        <a href="/invoices/pdf?id=<?= $id ?>" class="btn btn-outline-secondary btn-sm" target="_blank"><i class="bi bi-file-pdf me-1"></i>PDF</a>
        <a href="/invoices/duplicate?id=<?= $id ?>" class="btn btn-outline-secondary btn-sm"><i class="bi bi-copy me-1"></i>Dupliceer</a>
        <a href="/invoices" class="btn btn-outline-secondary btn-sm">Terug</a>
    </div>
</div>

<div class="row g-3">
    <div class="col-md-8">
        <!-- Invoice details card -->
        <div class="card mb-3">
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-6">
                        <h6 class="text-muted small">FACTUUR AAN</h6>
                        <strong><?= e($inv['customer_name']) ?></strong>
                        <?php if ($inv['company_name']): ?><br><?= e($inv['company_name']) ?><?php endif; ?>
                        <?php if ($inv['billing_street']): ?><br><?= e($inv['billing_street']) ?><?php endif; ?>
                        <?php if ($inv['billing_postal_code'] || $inv['billing_city']): ?><br><?= e($inv['billing_postal_code']) ?> <?= e($inv['billing_city']) ?><?php endif; ?>
                        <?php if ($inv['customer_vat']): ?><br>BTW: <?= e($inv['customer_vat']) ?><?php endif; ?>
                    </div>
                    <div class="col-6 text-end">
                        <p class="mb-1"><strong>Factuurnummer:</strong> <?= e($inv['invoice_number'] ?: '-') ?></p>
                        <p class="mb-1"><strong>Datum:</strong> <?= formatDate($inv['issue_date']) ?></p>
                        <p class="mb-1"><strong>Vervaldatum:</strong> <?= formatDate($inv['due_date']) ?></p>
                        <?php if ($inv['payment_reference']): ?>
                        <p class="mb-1"><strong>Referentie:</strong> <?= e($inv['payment_reference']) ?></p>
                        <?php endif; ?>
                    </div>
                </div>

                <table class="table table-sm">
                    <thead><tr><th>Omschrijving</th><th class="text-end">Aantal</th><th class="text-end">Prijs</th><th class="text-end">BTW</th><th class="text-end">Totaal</th></tr></thead>
                    <tbody>
                    <?php foreach ($lines as $line): ?>
                    <tr>
                        <td><?= e($line['description']) ?></td>
                        <td class="text-end"><?= $line['quantity'] ?> <?= e($line['unit']) ?></td>
                        <td class="text-end"><?= formatMoney($line['unit_price']) ?></td>
                        <td class="text-end"><?= $line['tax_rate'] ?>%</td>
                        <td class="text-end"><?= formatMoney($line['line_subtotal']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr><td colspan="4" class="text-end">Subtotaal:</td><td class="text-end"><?= formatMoney($inv['subtotal']) ?></td></tr>
                        <tr><td colspan="4" class="text-end">BTW:</td><td class="text-end"><?= formatMoney($inv['tax_total']) ?></td></tr>
                        <tr class="fw-bold"><td colspan="4" class="text-end">Totaal:</td><td class="text-end"><?= formatMoney($inv['total'], $inv['currency']) ?></td></tr>
                        <?php if ($inv['amount_paid'] > 0): ?>
                        <tr class="text-success"><td colspan="4" class="text-end">Betaald:</td><td class="text-end">-<?= formatMoney($inv['amount_paid']) ?></td></tr>
                        <tr class="fw-bold"><td colspan="4" class="text-end">Openstaand:</td><td class="text-end"><?= formatMoney($inv['amount_due'], $inv['currency']) ?></td></tr>
                        <?php endif; ?>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <!-- Payments -->
        <div class="card mb-3">
            <div class="card-header">Betalingen</div>
            <div class="card-body">
                <?php if (empty($payments)): ?>
                <p class="text-muted small mb-0">Nog geen betalingen geregistreerd.</p>
                <?php else: foreach ($payments as $p): ?>
                <div class="d-flex justify-content-between align-items-center mb-2 pb-2 border-bottom">
                    <div>
                        <strong class="text-success"><?= formatMoney($p['amount']) ?></strong><br>
                        <small class="text-muted"><?= formatDate($p['paid_at']) ?> · <?= e($p['method']) ?></small>
                    </div>
                    <?php if ($p['reference']): ?><small class="text-muted"><?= e($p['reference']) ?></small><?php endif; ?>
                </div>
                <?php endforeach; endif; ?>
            </div>
        </div>
        <!-- Reminders -->
        <div class="card mb-3">
            <div class="card-header">Herinneringen</div>
            <div class="card-body">
                <?php if (empty($reminders)): ?>
                <p class="text-muted small mb-0">Geen herinneringen verstuurd.</p>
                <?php else: foreach ($reminders as $r): ?>
                <div class="mb-2">
                    <span class="badge bg-secondary"><?= e($r['stage']) ?></span>
                    <small class="text-muted ms-1"><?= formatDate($r['sent_at'], 'd-m-Y H:i') ?></small>
                    <?= statusBadge($r['status']) ?>
                </div>
                <?php endforeach; endif; ?>
            </div>
        </div>
        <!-- Notes -->
        <?php if ($inv['notes']): ?>
        <div class="card">
            <div class="card-header">Interne notities</div>
            <div class="card-body small"><?= nl2br(e($inv['notes'])) ?></div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Factuur ' . ($inv['invoice_number'] ?: 'Concept'), 'currentPage' => 'invoices', 'content' => $content]);
