<?php
Auth::requirePermission('invoices', 'edit');
$db = Database::get();
$id = (int)($_POST['id'] ?? 0);

$stmt = $db->prepare('SELECT * FROM invoices WHERE id = ? AND status = ?');
$stmt->execute([$id, 'draft']);
$inv = $stmt->fetch();
if (!$inv) { Flash::error('Factuur niet gevonden of niet bewerkbaar.'); redirect('/invoices'); }

$db->beginTransaction();
try {
    // Update header
    $stmt = $db->prepare('UPDATE invoices SET customer_id=?, issue_date=?, due_date=?, payment_reference=?, notes=?, terms=? WHERE id=?');
    $stmt->execute([
        $_POST['customer_id'], $_POST['issue_date'] ?? null, $_POST['due_date'] ?? null,
        $_POST['payment_reference'] ?? null, $_POST['notes'] ?? null, $_POST['terms'] ?? null, $id,
    ]);

    // Delete old lines
    $db->prepare("DELETE FROM document_lines WHERE document_type = 'invoice' AND document_id = ?")->execute([$id]);

    // Insert new lines
    $subtotal = 0; $taxTotal = 0; $sort = 0;
    foreach ($_POST['lines'] ?? [] as $line) {
        $desc = trim($line['description'] ?? '');
        if (!$desc) continue;
        $qty = (float)($line['quantity'] ?? 1);
        $price = (float)($line['unit_price'] ?? 0);
        $taxRate = (float)($line['tax_rate'] ?? 21);
        $lineSubtotal = round($qty * $price, 2);
        $lineTax = round($lineSubtotal * ($taxRate / 100), 2);
        $subtotal += $lineSubtotal;
        $taxTotal += $lineTax;

        $db->prepare('INSERT INTO document_lines (document_type, document_id, item_id, sort_order, description, quantity, unit, unit_price, tax_rate, line_subtotal, line_tax, line_total) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)')
           ->execute(['invoice', $id, $line['item_id'] ?: null, $sort++, $desc, $qty, $line['unit'] ?? 'stuk', $price, $taxRate, $lineSubtotal, $lineTax, $lineSubtotal + $lineTax]);
    }

    $total = $subtotal + $taxTotal;
    $amountPaid = (float)$inv['amount_paid'];
    $db->prepare('UPDATE invoices SET subtotal=?, tax_total=?, total=?, amount_due=? WHERE id=?')
       ->execute([$subtotal, $taxTotal, $total, $total - $amountPaid, $id]);

    $db->commit();
    AuditLog::log('invoice', $id, 'updated', null, ['total' => $total]);
    Flash::success('Factuur bijgewerkt.');
    redirect("/invoices/view?id=$id");
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout: ' . $e->getMessage());
    redirect("/invoices/edit?id=$id");
}
