<?php
Auth::requirePermission('invoices', 'create');
$db = Database::get();

$customerId = (int)($_POST['customer_id'] ?? 0);
if (!$customerId) { Flash::error('Selecteer een klant.'); redirect('/invoices/create'); }

$lines = $_POST['lines'] ?? [];
if (empty($lines)) { Flash::error('Voeg minimaal één regel toe.'); redirect('/invoices/create'); }

$db->beginTransaction();
try {
    // Create invoice
    $stmt = $db->prepare(
        'INSERT INTO invoices (customer_id, status, issue_date, due_date, payment_reference, notes, terms, currency, language, created_by)
         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)'
    );
    
    // Get customer defaults
    $stmt2 = $db->prepare('SELECT currency, language FROM customers WHERE id = ?');
    $stmt2->execute([$customerId]);
    $cust = $stmt2->fetch();
    
    $stmt->execute([
        $customerId,
        'draft',
        $_POST['issue_date'] ?? date('Y-m-d'),
        $_POST['due_date'] ?? date('Y-m-d', strtotime('+30 days')),
        $_POST['payment_reference'] ?? null,
        $_POST['notes'] ?? null,
        $_POST['terms'] ?? null,
        $cust['currency'] ?? 'EUR',
        $cust['language'] ?? 'nl',
        Auth::userId(),
    ]);
    $invoiceId = $db->lastInsertId();

    // Insert lines & calculate totals
    $subtotal = 0;
    $taxTotal = 0;
    $sort = 0;

    foreach ($lines as $line) {
        $desc = trim($line['description'] ?? '');
        if (!$desc) continue;

        $qty = (float)($line['quantity'] ?? 1);
        $price = (float)($line['unit_price'] ?? 0);
        $taxRate = (float)($line['tax_rate'] ?? 21);

        $lineSubtotal = round($qty * $price, 2);
        $lineTax = round($lineSubtotal * ($taxRate / 100), 2);
        $lineTotal = $lineSubtotal + $lineTax;

        $subtotal += $lineSubtotal;
        $taxTotal += $lineTax;

        $stmt = $db->prepare(
            'INSERT INTO document_lines (document_type, document_id, item_id, sort_order, description, quantity, unit, unit_price, tax_rate, line_subtotal, line_tax, line_total)
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)'
        );
        $stmt->execute([
            'invoice', $invoiceId, $line['item_id'] ?: null, $sort++,
            $desc, $qty, $line['unit'] ?? 'stuk', $price, $taxRate,
            $lineSubtotal, $lineTax, $lineTotal,
        ]);
    }

    $total = $subtotal + $taxTotal;
    $stmt = $db->prepare('UPDATE invoices SET subtotal=?, tax_total=?, total=?, amount_due=? WHERE id=?');
    $stmt->execute([$subtotal, $taxTotal, $total, $total, $invoiceId]);

    $db->commit();
    AuditLog::log('invoice', $invoiceId, 'created', null, ['total' => $total]);
    Flash::success('Factuur aangemaakt.');
    redirect("/invoices/view?id=$invoiceId");
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout bij aanmaken: ' . $e->getMessage());
    redirect('/invoices/create');
}
