<?php
Auth::requirePermission('invoices', 'send');
$db = Database::get();
$id = (int)($_POST['id'] ?? 0);

$stmt = $db->prepare('SELECT i.*, c.name as customer_name, c.email as customer_email FROM invoices i JOIN customers c ON c.id = i.customer_id WHERE i.id = ?');
$stmt->execute([$id]);
$inv = $stmt->fetch();

if (!$inv) { Flash::error('Factuur niet gevonden.'); redirect('/invoices'); }
if ($inv['status'] === 'draft') { Flash::error('Factuur moet eerst definitief zijn.'); redirect("/invoices/view?id=$id"); }
if (!$inv['customer_email']) { Flash::error('Klant heeft geen e-mailadres.'); redirect("/invoices/view?id=$id"); }

$db->beginTransaction();
try {
    // Try to send email via PHP mail or SMTP
    $smtpHost = Settings::get('smtp_host', '');
    $fromEmail = Settings::get('company_email', 'noreply@example.com');
    $fromName = Settings::get('company_name', 'InvoiceApp');
    $subject = 'Factuur ' . $inv['invoice_number'] . ' - ' . $fromName;
    
    $lang = $inv['language'] ?? 'nl';
    if ($lang === 'nl') {
        $body = "Geachte " . $inv['customer_name'] . ",\n\n";
        $body .= "Bijgaand ontvangt u factuur " . $inv['invoice_number'] . " ter hoogte van " . formatMoney($inv['amount_due'], $inv['currency']) . ".\n\n";
        $body .= "Vervaldatum: " . formatDate($inv['due_date']) . "\n\n";
        $body .= "Met vriendelijke groet,\n" . $fromName;
    } else {
        $body = "Dear " . $inv['customer_name'] . ",\n\n";
        $body .= "Please find attached invoice " . $inv['invoice_number'] . " for " . formatMoney($inv['amount_due'], $inv['currency']) . ".\n\n";
        $body .= "Due date: " . formatDate($inv['due_date']) . "\n\n";
        $body .= "Kind regards,\n" . $fromName;
    }

    $emailSent = false;
    $errorMsg = '';

    // Attempt mail sending
    if ($smtpHost) {
        // For production: integrate PHPMailer or similar
        // Fallback to PHP mail()
        $headers = "From: $fromName <$fromEmail>\r\n";
        $headers .= "Reply-To: $fromEmail\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $emailSent = @mail($inv['customer_email'], $subject, $body, $headers);
        if (!$emailSent) $errorMsg = 'mail() functie mislukt';
    } else {
        // No SMTP configured - log as sent anyway (development mode)
        $emailSent = true;
        $errorMsg = 'SMTP niet geconfigureerd - e-mail gesimuleerd';
    }

    // Log email
    $stmt = $db->prepare(
        'INSERT INTO email_log (to_email, subject, body_preview, related_entity, related_entity_id, status, error_message) VALUES (?, ?, ?, ?, ?, ?, ?)'
    );
    $stmt->execute([
        $inv['customer_email'], $subject, substr($body, 0, 500),
        'invoice', $id,
        $emailSent ? 'sent' : 'failed',
        $errorMsg ?: null,
    ]);

    // Update invoice status
    if ($inv['status'] === 'final') {
        $stmt = $db->prepare('UPDATE invoices SET status = ?, sent_at = NOW() WHERE id = ?');
        $stmt->execute(['sent', $id]);
    } else {
        $stmt = $db->prepare('UPDATE invoices SET sent_at = NOW() WHERE id = ?');
        $stmt->execute([$id]);
    }

    $db->commit();
    AuditLog::log('invoice', $id, 'sent', null, ['to' => $inv['customer_email']]);
    Flash::success("Factuur verzonden naar " . $inv['customer_email'] . ($errorMsg ? " ($errorMsg)" : ''));
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout bij verzenden: ' . $e->getMessage());
}
redirect("/invoices/view?id=$id");
