<?php
Auth::requirePermission('invoices', 'view');
$db = Database::get();
$id = (int)($_GET['id'] ?? 0);

$stmt = $db->prepare('SELECT i.*, c.name as customer_name, c.company_name, c.email as customer_email, c.vat_number as customer_vat, c.billing_street, c.billing_city, c.billing_postal_code, c.billing_country FROM invoices i JOIN customers c ON c.id = i.customer_id WHERE i.id = ?');
$stmt->execute([$id]);
$inv = $stmt->fetch();
if (!$inv) { Flash::error('Factuur niet gevonden.'); redirect('/invoices'); }

$stmt = $db->prepare("SELECT * FROM document_lines WHERE document_type = 'invoice' AND document_id = ? ORDER BY sort_order");
$stmt->execute([$id]);
$lines = $stmt->fetchAll();

// Company info
$company = [
    'name' => Settings::get('company_name', 'Mijn Bedrijf'),
    'street' => Settings::get('company_street', ''),
    'city' => Settings::get('company_city', ''),
    'postal' => Settings::get('company_postal_code', ''),
    'country' => Settings::get('company_country', 'NL'),
    'vat' => Settings::get('company_vat_number', ''),
    'kvk' => Settings::get('company_kvk_number', ''),
    'iban' => Settings::get('company_iban', ''),
    'email' => Settings::get('company_email', ''),
    'phone' => Settings::get('company_phone', ''),
];

$lang = $inv['language'] ?? 'nl';
$labels = [
    'nl' => ['invoice' => 'FACTUUR', 'quote' => 'OFFERTE', 'credit' => 'CREDITNOTA', 'date' => 'Datum', 'due_date' => 'Vervaldatum', 'number' => 'Factuurnummer', 'ref' => 'Referentie', 'to' => 'Factuur aan', 'desc' => 'Omschrijving', 'qty' => 'Aantal', 'price' => 'Prijs', 'vat' => 'BTW', 'total' => 'Totaal', 'subtotal' => 'Subtotaal', 'tax' => 'BTW', 'amount_due' => 'Te betalen', 'paid' => 'Betaald', 'payment_info' => 'Betaalgegevens', 'iban' => 'IBAN', 'terms' => 'Voorwaarden', 'page' => 'Pagina'],
    'en' => ['invoice' => 'INVOICE', 'quote' => 'QUOTE', 'credit' => 'CREDIT NOTE', 'date' => 'Date', 'due_date' => 'Due date', 'number' => 'Invoice number', 'ref' => 'Reference', 'to' => 'Bill to', 'desc' => 'Description', 'qty' => 'Quantity', 'price' => 'Price', 'vat' => 'VAT', 'total' => 'Total', 'subtotal' => 'Subtotal', 'tax' => 'VAT', 'amount_due' => 'Amount due', 'paid' => 'Paid', 'payment_info' => 'Payment details', 'iban' => 'IBAN', 'terms' => 'Terms', 'page' => 'Page'],
];
$l = $labels[$lang] ?? $labels['nl'];

$currSymbol = ['EUR' => '€', 'USD' => '$', 'GBP' => '£'][$inv['currency']] ?? $inv['currency'];
$fmt = function($amount) use ($currSymbol) { return $currSymbol . ' ' . number_format((float)$amount, 2, ',', '.'); };

// Generate HTML for PDF
$html = '<!DOCTYPE html><html><head><meta charset="UTF-8"><style>
body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 10pt; color: #333; margin: 0; padding: 0; }
.header { margin-bottom: 30px; }
.company-name { font-size: 18pt; font-weight: bold; color: #1e293b; }
.company-details { font-size: 8pt; color: #64748b; margin-top: 4px; }
.doc-title { font-size: 22pt; font-weight: bold; color: #2563eb; margin: 25px 0 15px; }
table.info { width: 100%; margin-bottom: 20px; }
table.info td { vertical-align: top; padding: 2px 0; }
.label { color: #64748b; font-size: 9pt; }
.section-title { font-size: 8pt; text-transform: uppercase; letter-spacing: 1px; color: #64748b; margin-bottom: 6px; font-weight: bold; }
table.lines { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
table.lines th { background: #f1f5f9; padding: 8px 10px; text-align: left; font-size: 8pt; text-transform: uppercase; letter-spacing: 0.5px; color: #64748b; border-bottom: 2px solid #e2e8f0; }
table.lines td { padding: 8px 10px; border-bottom: 1px solid #e2e8f0; }
table.lines .right { text-align: right; }
table.totals { float: right; width: 250px; margin-bottom: 25px; }
table.totals td { padding: 4px 10px; }
table.totals .total-row { font-weight: bold; font-size: 12pt; border-top: 2px solid #1e293b; }
table.totals .right { text-align: right; }
.payment-box { background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 4px; padding: 12px 15px; margin-top: 40px; }
.payment-box .title { font-weight: bold; margin-bottom: 5px; }
.terms { margin-top: 20px; font-size: 9pt; color: #64748b; }
.footer { position: fixed; bottom: 0; left: 0; right: 0; text-align: center; font-size: 7pt; color: #94a3b8; padding: 10px; border-top: 1px solid #e2e8f0; }
</style></head><body>';

// Header
$html .= '<div class="header">';
$html .= '<div class="company-name">' . htmlspecialchars($company['name']) . '</div>';
$html .= '<div class="company-details">';
$details = array_filter([$company['street'], $company['postal'] . ' ' . $company['city'], $company['phone'], $company['email']]);
$html .= implode(' &middot; ', array_map('htmlspecialchars', $details));
$html .= '</div></div>';

// Document title
$html .= '<div class="doc-title">' . $l['invoice'] . '</div>';

// Info table
$html .= '<table class="info"><tr><td style="width:50%">';
$html .= '<div class="section-title">' . $l['to'] . '</div>';
$html .= '<strong>' . htmlspecialchars($inv['customer_name']) . '</strong><br>';
if ($inv['company_name']) $html .= htmlspecialchars($inv['company_name']) . '<br>';
if ($inv['billing_street']) $html .= htmlspecialchars($inv['billing_street']) . '<br>';
$html .= htmlspecialchars(trim($inv['billing_postal_code'] . ' ' . $inv['billing_city'])) . '<br>';
if ($inv['customer_vat']) $html .= 'BTW: ' . htmlspecialchars($inv['customer_vat']);
$html .= '</td><td style="text-align:right">';
$html .= '<table style="float:right"><tr><td class="label">' . $l['number'] . ':</td><td><strong>' . htmlspecialchars($inv['invoice_number'] ?: '-') . '</strong></td></tr>';
$html .= '<tr><td class="label">' . $l['date'] . ':</td><td>' . formatDate($inv['issue_date']) . '</td></tr>';
$html .= '<tr><td class="label">' . $l['due_date'] . ':</td><td>' . formatDate($inv['due_date']) . '</td></tr>';
if ($inv['payment_reference']) $html .= '<tr><td class="label">' . $l['ref'] . ':</td><td>' . htmlspecialchars($inv['payment_reference']) . '</td></tr>';
$html .= '</table></td></tr></table>';

// Lines table
$html .= '<table class="lines"><thead><tr><th>' . $l['desc'] . '</th><th class="right">' . $l['qty'] . '</th><th class="right">' . $l['price'] . '</th><th class="right">' . $l['vat'] . '</th><th class="right">' . $l['total'] . '</th></tr></thead><tbody>';
foreach ($lines as $line) {
    $html .= '<tr>';
    $html .= '<td>' . htmlspecialchars($line['description']) . '</td>';
    $html .= '<td class="right">' . $line['quantity'] . ' ' . htmlspecialchars($line['unit']) . '</td>';
    $html .= '<td class="right">' . $fmt($line['unit_price']) . '</td>';
    $html .= '<td class="right">' . $line['tax_rate'] . '%</td>';
    $html .= '<td class="right">' . $fmt($line['line_subtotal']) . '</td>';
    $html .= '</tr>';
}
$html .= '</tbody></table>';

// Totals
$html .= '<table class="totals">';
$html .= '<tr><td>' . $l['subtotal'] . ':</td><td class="right">' . $fmt($inv['subtotal']) . '</td></tr>';
$html .= '<tr><td>' . $l['tax'] . ':</td><td class="right">' . $fmt($inv['tax_total']) . '</td></tr>';
if ($inv['amount_paid'] > 0) {
    $html .= '<tr><td>' . $l['paid'] . ':</td><td class="right">-' . $fmt($inv['amount_paid']) . '</td></tr>';
    $html .= '<tr class="total-row"><td>' . $l['amount_due'] . ':</td><td class="right">' . $fmt($inv['amount_due']) . '</td></tr>';
} else {
    $html .= '<tr class="total-row"><td>' . $l['total'] . ':</td><td class="right">' . $fmt($inv['total']) . '</td></tr>';
}
$html .= '</table><div style="clear:both"></div>';

// Payment info
$html .= '<div class="payment-box"><div class="title">' . $l['payment_info'] . '</div>';
$html .= $l['iban'] . ': <strong>' . htmlspecialchars($company['iban']) . '</strong><br>';
$html .= 'BIC: ' . htmlspecialchars(Settings::get('company_bic', '')) . '<br>';
$html .= 't.n.v. ' . htmlspecialchars($company['name']) . '<br>';
$html .= 'o.v.v. ' . htmlspecialchars($inv['invoice_number'] ?: '');
$html .= '</div>';

// Terms
if ($inv['terms']) {
    $html .= '<div class="terms"><strong>' . $l['terms'] . ':</strong><br>' . nl2br(htmlspecialchars($inv['terms'])) . '</div>';
}

// Footer
$html .= '<div class="footer">' . htmlspecialchars($company['name']);
if ($company['kvk']) $html .= ' &middot; KVK: ' . htmlspecialchars($company['kvk']);
if ($company['vat']) $html .= ' &middot; BTW: ' . htmlspecialchars($company['vat']);
$html .= '</div>';

$html .= '</body></html>';

// Check if Dompdf is available
$dompdfAutoload = __DIR__ . '/../../vendor/autoload.php';
if (file_exists($dompdfAutoload)) {
    require_once $dompdfAutoload;
    $options = new \Dompdf\Options();
    $options->set('isHtml5ParserEnabled', true);
    $options->set('isRemoteEnabled', false);
    $options->set('defaultFont', 'DejaVu Sans');
    $dompdf = new \Dompdf\Dompdf($options);
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    
    $filename = ($inv['invoice_number'] ?: 'concept-' . $id) . '.pdf';
    
    // Save PDF
    $storagePath = __DIR__ . '/../../storage/pdf/';
    if (!is_dir($storagePath)) mkdir($storagePath, 0755, true);
    file_put_contents($storagePath . $filename, $dompdf->output());
    
    // Update pdf_path
    $stmt = $db->prepare('UPDATE invoices SET pdf_path = ? WHERE id = ?');
    $stmt->execute([$filename, $id]);
    
    // Stream to browser
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="' . $filename . '"');
    $dompdf->stream($filename, ['Attach' => false]);
} else {
    // Fallback: render HTML directly (for development without Dompdf)
    header('Content-Type: text/html; charset=UTF-8');
    echo $html;
}
