<?php
Auth::requirePermission('invoices', 'view');
$db = Database::get();
$page = max(1, (int)($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');
$status = $_GET['status'] ?? '';

$where = '1=1';
$params = [];

if ($search) {
    $where .= ' AND (i.invoice_number LIKE ? OR c.name LIKE ?)';
    $params[] = "%$search%";
    $params[] = "%$search%";
}
if ($status) {
    $where .= ' AND i.status = ?';
    $params[] = $status;
}

$query = "SELECT i.*, c.name as customer_name FROM invoices i JOIN customers c ON c.id = i.customer_id WHERE $where ORDER BY i.created_at DESC";
$result = paginate($query, $params, $page);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Facturen</h5>
    <?php if (Auth::hasPermission('invoices', 'create')): ?>
    <a href="/invoices/create" class="btn btn-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Nieuwe factuur</a>
    <?php endif; ?>
</div>
<div class="card">
    <div class="card-header">
        <form method="GET" class="d-flex gap-2 flex-wrap">
            <input type="text" name="search" class="form-control form-control-sm" placeholder="Zoek op nummer of klant..." value="<?= e($search) ?>" style="max-width:250px">
            <select name="status" class="form-select form-select-sm" style="max-width:180px" onchange="this.form.submit()">
                <option value="">Alle statussen</option>
                <?php foreach (['draft'=>'Concept','final'=>'Definitief','sent'=>'Verzonden','overdue'=>'Te laat','partially_paid'=>'Deels betaald','paid'=>'Betaald','cancelled'=>'Geannuleerd'] as $k=>$v): ?>
                <option value="<?= $k ?>" <?= $status === $k ? 'selected' : '' ?>><?= $v ?></option>
                <?php endforeach; ?>
            </select>
            <button class="btn btn-sm btn-outline-secondary">Zoeken</button>
        </form>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead><tr><th>Nummer</th><th>Klant</th><th>Datum</th><th>Vervaldatum</th><th>Bedrag</th><th>Openstaand</th><th>Status</th><th></th></tr></thead>
            <tbody>
            <?php if (empty($result['items'])): ?>
            <tr><td colspan="8" class="text-center text-muted py-4">Geen facturen gevonden</td></tr>
            <?php else: foreach ($result['items'] as $inv): ?>
            <tr>
                <td><a href="/invoices/view?id=<?= $inv['id'] ?>"><?= e($inv['invoice_number'] ?: 'Concept') ?></a></td>
                <td><?= e($inv['customer_name']) ?></td>
                <td><?= formatDate($inv['issue_date']) ?></td>
                <td><?= formatDate($inv['due_date']) ?></td>
                <td><?= formatMoney($inv['total'], $inv['currency']) ?></td>
                <td><?= formatMoney($inv['amount_due'], $inv['currency']) ?></td>
                <td><?= statusBadge($inv['status']) ?></td>
                <td class="text-end">
                    <?php if ($inv['status'] === 'draft'): ?>
                    <a href="/invoices/edit?id=<?= $inv['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
    <?php if ($result['total_pages'] > 1): ?>
    <div class="card-footer">
        <nav><ul class="pagination pagination-sm mb-0 justify-content-center">
            <?php for ($i = 1; $i <= $result['total_pages']; $i++): ?>
            <li class="page-item <?= $i === $result['page'] ? 'active' : '' ?>">
                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>&status=<?= urlencode($status) ?>"><?= $i ?></a>
            </li>
            <?php endfor; ?>
        </ul></nav>
    </div>
    <?php endif; ?>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Facturen', 'currentPage' => 'invoices', 'content' => $content]);
