<?php
Auth::requirePermission('invoices', 'finalize');
$db = Database::get();
$id = (int)($_POST['id'] ?? 0);

$stmt = $db->prepare('SELECT * FROM invoices WHERE id = ?');
$stmt->execute([$id]);
$inv = $stmt->fetch();

if (!$inv) { Flash::error('Factuur niet gevonden.'); redirect('/invoices'); }
if ($inv['status'] !== 'draft') { Flash::error('Alleen conceptfacturen kunnen definitief gemaakt worden.'); redirect("/invoices/view?id=$id"); }

$db->beginTransaction();
try {
    $invoiceNumber = NumberGenerator::nextInvoiceNumber();
    
    $stmt = $db->prepare(
        'UPDATE invoices SET invoice_number = ?, status = ?, finalized_at = NOW(), issue_date = COALESCE(issue_date, CURDATE()), 
         due_date = COALESCE(due_date, DATE_ADD(CURDATE(), INTERVAL ? DAY))
         WHERE id = ? AND status = ?'
    );
    $paymentTerms = (int)Settings::get('default_payment_terms', 30);
    $stmt->execute([$invoiceNumber, 'final', $paymentTerms, $id, 'draft']);
    
    if ($stmt->rowCount() === 0) {
        throw new RuntimeException('Factuur kon niet gefinaliseerd worden (status was veranderd).');
    }
    
    $db->commit();
    AuditLog::log('invoice', $id, 'finalized', ['status' => 'draft'], ['status' => 'final', 'invoice_number' => $invoiceNumber]);
    Flash::success("Factuur $invoiceNumber is definitief gemaakt.");
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout: ' . $e->getMessage());
}
redirect("/invoices/view?id=$id");
