<?php
Auth::requirePermission('invoices', 'edit');
$db = Database::get();
$id = (int)($_GET['id'] ?? 0);

$stmt = $db->prepare('SELECT * FROM invoices WHERE id = ?');
$stmt->execute([$id]);
$invoice = $stmt->fetch();
if (!$invoice) { Flash::error('Factuur niet gevonden.'); redirect('/invoices'); }
if ($invoice['status'] !== 'draft') { Flash::error('Alleen conceptfacturen kunnen bewerkt worden.'); redirect("/invoices/view?id=$id"); }

$stmt = $db->prepare("SELECT * FROM document_lines WHERE document_type = 'invoice' AND document_id = ? ORDER BY sort_order");
$stmt->execute([$id]);
$lines = $stmt->fetchAll();

ob_start();
include __DIR__ . '/../../templates/invoices/form.php';
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Factuur bewerken', 'currentPage' => 'invoices', 'content' => $content]);
