<?php
Auth::requirePermission('invoices', 'create');
$db = Database::get();
$id = (int)($_GET['id'] ?? 0);

$stmt = $db->prepare('SELECT * FROM invoices WHERE id = ?');
$stmt->execute([$id]);
$inv = $stmt->fetch();
if (!$inv) { Flash::error('Factuur niet gevonden.'); redirect('/invoices'); }

$stmt = $db->prepare("SELECT * FROM document_lines WHERE document_type = 'invoice' AND document_id = ? ORDER BY sort_order");
$stmt->execute([$id]);
$lines = $stmt->fetchAll();

$db->beginTransaction();
try {
    $stmt = $db->prepare(
        'INSERT INTO invoices (customer_id, status, issue_date, due_date, payment_reference, notes, terms, currency, language, subtotal, tax_total, total, amount_due, created_by)
         VALUES (?, ?, CURDATE(), DATE_ADD(CURDATE(), INTERVAL ? DAY), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)'
    );
    $paymentTerms = (int)Settings::get('default_payment_terms', 30);
    $stmt->execute([
        $inv['customer_id'], 'draft', $paymentTerms, $inv['payment_reference'],
        $inv['notes'], $inv['terms'], $inv['currency'], $inv['language'],
        $inv['subtotal'], $inv['tax_total'], $inv['total'], $inv['total'], Auth::userId()
    ]);
    $newId = $db->lastInsertId();

    foreach ($lines as $sort => $line) {
        $stmt = $db->prepare(
            'INSERT INTO document_lines (document_type, document_id, item_id, sort_order, description, quantity, unit, unit_price, tax_rate, line_subtotal, line_tax, line_total)
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)'
        );
        $stmt->execute([
            'invoice', $newId, $line['item_id'], $sort,
            $line['description'], $line['quantity'], $line['unit'], $line['unit_price'],
            $line['tax_rate'], $line['line_subtotal'], $line['line_tax'], $line['line_total']
        ]);
    }

    $db->commit();
    AuditLog::log('invoice', $newId, 'duplicated', null, ['source_invoice_id' => $id]);
    Flash::success('Factuur gedupliceerd als nieuw concept.');
    redirect("/invoices/view?id=$newId");
} catch (\Exception $e) {
    $db->rollBack();
    Flash::error('Fout bij dupliceren: ' . $e->getMessage());
    redirect("/invoices/view?id=$id");
}
