<?php
// GET /dashboard
$db = Database::get();

// Revenue MTD
$stmt = $db->prepare("SELECT COALESCE(SUM(total), 0) FROM invoices WHERE status IN ('sent','paid','partially_paid','overdue') AND MONTH(issue_date) = MONTH(CURRENT_DATE()) AND YEAR(issue_date) = YEAR(CURRENT_DATE())");
$stmt->execute();
$revenueMtd = (float)$stmt->fetchColumn();

// Revenue YTD
$stmt = $db->prepare("SELECT COALESCE(SUM(total), 0) FROM invoices WHERE status IN ('sent','paid','partially_paid','overdue') AND YEAR(issue_date) = YEAR(CURRENT_DATE())");
$stmt->execute();
$revenueYtd = (float)$stmt->fetchColumn();

// Outstanding amount
$stmt = $db->prepare("SELECT COALESCE(SUM(amount_due), 0) FROM invoices WHERE status IN ('sent','overdue','partially_paid') AND amount_due > 0");
$stmt->execute();
$outstanding = (float)$stmt->fetchColumn();

// Overdue count
$stmt = $db->prepare("SELECT COUNT(*) FROM invoices WHERE status IN ('sent','overdue','partially_paid') AND due_date < CURRENT_DATE() AND amount_due > 0");
$stmt->execute();
$overdueCount = (int)$stmt->fetchColumn();

// Total customers
$stmt = $db->prepare("SELECT COUNT(*) FROM customers WHERE archived_at IS NULL");
$stmt->execute();
$totalCustomers = (int)$stmt->fetchColumn();

// Recent invoices
$stmt = $db->prepare(
    "SELECT i.*, c.name as customer_name FROM invoices i
     JOIN customers c ON c.id = i.customer_id
     ORDER BY i.created_at DESC LIMIT 10"
);
$stmt->execute();
$recentInvoices = $stmt->fetchAll();

// Aging breakdown
$aging = ['current' => 0, '30' => 0, '60' => 0, '90' => 0, '90plus' => 0];
$stmt = $db->prepare(
    "SELECT amount_due, DATEDIFF(CURRENT_DATE(), due_date) as days_overdue
     FROM invoices WHERE status IN ('sent','overdue','partially_paid') AND amount_due > 0"
);
$stmt->execute();
foreach ($stmt->fetchAll() as $row) {
    $days = (int)$row['days_overdue'];
    if ($days <= 0) $aging['current'] += $row['amount_due'];
    elseif ($days <= 30) $aging['30'] += $row['amount_due'];
    elseif ($days <= 60) $aging['60'] += $row['amount_due'];
    elseif ($days <= 90) $aging['90'] += $row['amount_due'];
    else $aging['90plus'] += $row['amount_due'];
}

// Render
ob_start();
?>
<div class="row g-3 mb-4">
    <div class="col-md-3 col-sm-6">
        <div class="stat-card d-flex align-items-center gap-3">
            <div class="stat-icon bg-primary bg-opacity-10 text-primary"><i class="bi bi-currency-euro"></i></div>
            <div>
                <div class="stat-value"><?= formatMoney($revenueMtd) ?></div>
                <div class="stat-label">Omzet deze maand</div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="stat-card d-flex align-items-center gap-3">
            <div class="stat-icon bg-success bg-opacity-10 text-success"><i class="bi bi-graph-up"></i></div>
            <div>
                <div class="stat-value"><?= formatMoney($revenueYtd) ?></div>
                <div class="stat-label">Omzet dit jaar</div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="stat-card d-flex align-items-center gap-3">
            <div class="stat-icon bg-warning bg-opacity-10 text-warning"><i class="bi bi-hourglass-split"></i></div>
            <div>
                <div class="stat-value"><?= formatMoney($outstanding) ?></div>
                <div class="stat-label">Openstaand</div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="stat-card d-flex align-items-center gap-3">
            <div class="stat-icon bg-danger bg-opacity-10 text-danger"><i class="bi bi-exclamation-triangle"></i></div>
            <div>
                <div class="stat-value"><?= $overdueCount ?></div>
                <div class="stat-label">Te laat</div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span>Recente facturen</span>
                <a href="/invoices" class="btn btn-sm btn-outline-primary">Alle facturen</a>
            </div>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead><tr><th>Nummer</th><th>Klant</th><th>Datum</th><th>Bedrag</th><th>Status</th></tr></thead>
                    <tbody>
                    <?php if (empty($recentInvoices)): ?>
                    <tr><td colspan="5" class="text-center text-muted py-4">Geen facturen gevonden</td></tr>
                    <?php else: foreach ($recentInvoices as $inv): ?>
                    <tr>
                        <td><a href="/invoices/view?id=<?= $inv['id'] ?>"><?= e($inv['invoice_number'] ?: 'Concept') ?></a></td>
                        <td><?= e($inv['customer_name']) ?></td>
                        <td><?= formatDate($inv['issue_date']) ?></td>
                        <td><?= formatMoney($inv['total'], $inv['currency']) ?></td>
                        <td><?= statusBadge($inv['status']) ?></td>
                    </tr>
                    <?php endforeach; endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">Ouderdom openstaande posten</div>
            <div class="card-body">
                <?php
                $agingLabels = [
                    'current' => ['Huidig (niet vervallen)', 'bg-success'],
                    '30' => ['1-30 dagen', 'bg-info'],
                    '60' => ['31-60 dagen', 'bg-warning'],
                    '90' => ['61-90 dagen', 'bg-orange'],
                    '90plus' => ['90+ dagen', 'bg-danger'],
                ];
                $agingTotal = array_sum($aging) ?: 1;
                foreach ($agingLabels as $key => [$label, $class]):
                    $pct = round($aging[$key] / $agingTotal * 100);
                ?>
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span class="small"><?= $label ?></span>
                    <span class="fw-semibold small"><?= formatMoney($aging[$key]) ?></span>
                </div>
                <div class="progress mb-3" style="height:6px">
                    <div class="progress-bar <?= $class ?>" style="width:<?= $pct ?>%"></div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="card mt-3">
            <div class="card-header">Snelle acties</div>
            <div class="card-body d-grid gap-2">
                <a href="/invoices/create" class="btn btn-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Nieuwe factuur</a>
                <a href="/quotes/create" class="btn btn-outline-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Nieuwe offerte</a>
                <a href="/customers/create" class="btn btn-outline-secondary btn-sm"><i class="bi bi-plus-lg me-1"></i>Nieuwe klant</a>
            </div>
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', [
    'pageTitle' => 'Dashboard',
    'currentPage' => 'dashboard',
    'content' => $content,
]);
