<?php
Auth::requirePermission('customers', 'view');
$db = Database::get();
$id = (int)($_GET['id'] ?? 0);

$stmt = $db->prepare('SELECT * FROM customers WHERE id = ?');
$stmt->execute([$id]);
$c = $stmt->fetch();
if (!$c) { Flash::error('Klant niet gevonden.'); redirect('/customers'); }

// Contacts
$stmt = $db->prepare('SELECT * FROM contacts WHERE customer_id = ? ORDER BY is_primary DESC, name');
$stmt->execute([$id]);
$contacts = $stmt->fetchAll();

// Recent invoices
$stmt = $db->prepare('SELECT * FROM invoices WHERE customer_id = ? ORDER BY created_at DESC LIMIT 20');
$stmt->execute([$id]);
$invoices = $stmt->fetchAll();

// Recent quotes
$stmt = $db->prepare('SELECT * FROM quotes WHERE customer_id = ? ORDER BY created_at DESC LIMIT 10');
$stmt->execute([$id]);
$quotes = $stmt->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><?= e($c['name']) ?> <?php if ($c['archived_at']): ?><span class="badge bg-secondary">Gearchiveerd</span><?php endif; ?></h5>
    <div class="d-flex gap-2">
        <a href="/invoices/create?customer_id=<?= $c['id'] ?>" class="btn btn-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Factuur</a>
        <a href="/customers/edit?id=<?= $c['id'] ?>" class="btn btn-outline-secondary btn-sm"><i class="bi bi-pencil me-1"></i>Bewerken</a>
        <?php if (!$c['archived_at'] && Auth::hasPermission('customers', 'archive')): ?>
        <form method="POST" action="/customers/archive" onsubmit="return confirm('Weet u het zeker?')">
            <?= CSRF::field() ?><input type="hidden" name="id" value="<?= $c['id'] ?>">
            <button class="btn btn-outline-danger btn-sm"><i class="bi bi-archive me-1"></i>Archiveren</button>
        </form>
        <?php endif; ?>
        <a href="/customers" class="btn btn-outline-secondary btn-sm">Terug</a>
    </div>
</div>

<div class="row g-3">
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">Gegevens</div>
            <div class="card-body small">
                <?php if ($c['company_name']): ?><p><strong>Bedrijf:</strong> <?= e($c['company_name']) ?></p><?php endif; ?>
                <?php if ($c['email']): ?><p><strong>E-mail:</strong> <a href="mailto:<?= e($c['email']) ?>"><?= e($c['email']) ?></a></p><?php endif; ?>
                <?php if ($c['phone']): ?><p><strong>Telefoon:</strong> <?= e($c['phone']) ?></p><?php endif; ?>
                <?php if ($c['vat_number']): ?><p><strong>BTW:</strong> <?= e($c['vat_number']) ?></p><?php endif; ?>
                <?php if ($c['kvk_number']): ?><p><strong>KVK:</strong> <?= e($c['kvk_number']) ?></p><?php endif; ?>
                <hr>
                <p class="mb-1"><strong>Factuuradres:</strong></p>
                <p class="mb-0"><?= e($c['billing_street'] ?? '') ?><br><?= e($c['billing_postal_code'] ?? '') ?> <?= e($c['billing_city'] ?? '') ?><br><?= e($c['billing_country'] ?? '') ?></p>
                <hr>
                <p><strong>Betaaltermijn:</strong> <?= $c['payment_terms'] ? $c['payment_terms'] . ' dagen' : 'Standaard' ?></p>
                <p><strong>Valuta:</strong> <?= e($c['currency']) ?></p>
                <p><strong>Taal:</strong> <?= e($c['language']) ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">Facturen</div>
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead><tr><th>Nummer</th><th>Datum</th><th>Bedrag</th><th>Openstaand</th><th>Status</th></tr></thead>
                    <tbody>
                    <?php if (empty($invoices)): ?>
                    <tr><td colspan="5" class="text-center text-muted py-3">Geen facturen</td></tr>
                    <?php else: foreach ($invoices as $inv): ?>
                    <tr>
                        <td><a href="/invoices/view?id=<?= $inv['id'] ?>"><?= e($inv['invoice_number'] ?: 'Concept') ?></a></td>
                        <td><?= formatDate($inv['issue_date']) ?></td>
                        <td><?= formatMoney($inv['total']) ?></td>
                        <td><?= formatMoney($inv['amount_due']) ?></td>
                        <td><?= statusBadge($inv['status']) ?></td>
                    </tr>
                    <?php endforeach; endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if (!empty($quotes)): ?>
        <div class="card">
            <div class="card-header">Offertes</div>
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead><tr><th>Nummer</th><th>Datum</th><th>Bedrag</th><th>Status</th></tr></thead>
                    <tbody>
                    <?php foreach ($quotes as $q): ?>
                    <tr>
                        <td><a href="/quotes/view?id=<?= $q['id'] ?>"><?= e($q['quote_number'] ?: 'Concept') ?></a></td>
                        <td><?= formatDate($q['issue_date']) ?></td>
                        <td><?= formatMoney($q['total']) ?></td>
                        <td><?= statusBadge($q['status']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Klant: ' . $c['name'], 'currentPage' => 'customers', 'content' => $content]);
