<?php
Auth::requirePermission('customers', 'edit');
$db = Database::get();
$id = (int)($_POST['id'] ?? 0);

$stmt = $db->prepare('SELECT * FROM customers WHERE id = ?');
$stmt->execute([$id]);
$old = $stmt->fetch();
if (!$old) { Flash::error('Klant niet gevonden.'); redirect('/customers'); }

$name = trim($_POST['name'] ?? '');
if (!$name) { Flash::error('Naam is verplicht.'); redirect("/customers/edit?id=$id"); }

$stmt = $db->prepare(
    'UPDATE customers SET name=?, company_name=?, email=?, phone=?, website=?, vat_number=?, kvk_number=?,
     billing_street=?, billing_city=?, billing_postal_code=?, billing_country=?,
     payment_terms=?, currency=?, language=?, notes=? WHERE id=?'
);
$stmt->execute([
    $name, $_POST['company_name'] ?? null, $_POST['email'] ?? null, $_POST['phone'] ?? null,
    $_POST['website'] ?? null, $_POST['vat_number'] ?? null, $_POST['kvk_number'] ?? null,
    $_POST['billing_street'] ?? null, $_POST['billing_city'] ?? null, $_POST['billing_postal_code'] ?? null,
    $_POST['billing_country'] ?? 'NL', $_POST['payment_terms'] ?: null,
    $_POST['currency'] ?? 'EUR', $_POST['language'] ?? 'nl', $_POST['notes'] ?? null, $id,
]);

AuditLog::log('customer', $id, 'updated', $old, ['name' => $name]);
Flash::success('Klant bijgewerkt.');
redirect("/customers/view?id=$id");
