<?php
// POST /customers/store
Auth::requirePermission('customers', 'create');
$db = Database::get();

$name = trim($_POST['name'] ?? '');
if (!$name) {
    Flash::error('Naam is verplicht.');
    setOldInput();
    redirect('/customers/create');
}

$stmt = $db->prepare(
    'INSERT INTO customers (name, company_name, email, phone, website, vat_number, kvk_number,
     billing_street, billing_city, billing_postal_code, billing_country,
     payment_terms, currency, language, notes)
     VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)'
);
$stmt->execute([
    $name,
    $_POST['company_name'] ?? null,
    $_POST['email'] ?? null,
    $_POST['phone'] ?? null,
    $_POST['website'] ?? null,
    $_POST['vat_number'] ?? null,
    $_POST['kvk_number'] ?? null,
    $_POST['billing_street'] ?? null,
    $_POST['billing_city'] ?? null,
    $_POST['billing_postal_code'] ?? null,
    $_POST['billing_country'] ?? 'NL',
    $_POST['payment_terms'] ?: null,
    $_POST['currency'] ?? 'EUR',
    $_POST['language'] ?? 'nl',
    $_POST['notes'] ?? null,
]);

$id = $db->lastInsertId();
AuditLog::log('customer', $id, 'created', null, ['name' => $name]);
Flash::success('Klant aangemaakt.');
clearOldInput();
redirect('/customers/view?id=' . $id);
