<?php
// GET /customers
Auth::requirePermission('customers', 'view');

$db = Database::get();
$page = max(1, (int)($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');
$showArchived = isset($_GET['archived']);

$where = $showArchived ? '1=1' : 'c.archived_at IS NULL';
$params = [];

if ($search) {
    $where .= ' AND (c.name LIKE ? OR c.company_name LIKE ? OR c.email LIKE ? OR c.vat_number LIKE ?)';
    $s = "%$search%";
    $params = [$s, $s, $s, $s];
}

$query = "SELECT c.*, 
    (SELECT COUNT(*) FROM invoices WHERE customer_id = c.id) as invoice_count,
    (SELECT COALESCE(SUM(amount_due), 0) FROM invoices WHERE customer_id = c.id AND status IN ('sent','overdue','partially_paid')) as open_balance
    FROM customers c WHERE $where ORDER BY c.name ASC";

$result = paginate($query, $params, $page);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h5 class="mb-0">Klanten</h5>
    </div>
    <?php if (Auth::hasPermission('customers', 'create')): ?>
    <a href="/customers/create" class="btn btn-primary btn-sm"><i class="bi bi-plus-lg me-1"></i>Nieuwe klant</a>
    <?php endif; ?>
</div>

<div class="card">
    <div class="card-header">
        <form method="GET" class="d-flex gap-2">
            <input type="text" name="search" class="form-control form-control-sm" placeholder="Zoeken..." value="<?= e($search) ?>" style="max-width:300px">
            <button class="btn btn-sm btn-outline-secondary">Zoeken</button>
            <label class="form-check-label ms-3 d-flex align-items-center gap-1 small">
                <input type="checkbox" name="archived" class="form-check-input" <?= $showArchived ? 'checked' : '' ?> onchange="this.form.submit()">
                Toon gearchiveerd
            </label>
        </form>
    </div>
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead><tr><th>Naam</th><th>E-mail</th><th>Plaats</th><th>Facturen</th><th>Openstaand</th><th></th></tr></thead>
            <tbody>
            <?php if (empty($result['items'])): ?>
            <tr><td colspan="6" class="text-center text-muted py-4">Geen klanten gevonden</td></tr>
            <?php else: foreach ($result['items'] as $c): ?>
            <tr<?= $c['archived_at'] ? ' class="text-muted"' : '' ?>>
                <td>
                    <a href="/customers/view?id=<?= $c['id'] ?>"><?= e($c['name']) ?></a>
                    <?php if ($c['company_name']): ?><br><small class="text-muted"><?= e($c['company_name']) ?></small><?php endif; ?>
                    <?php if ($c['archived_at']): ?> <span class="badge bg-secondary">Gearchiveerd</span><?php endif; ?>
                </td>
                <td><?= e($c['email'] ?? '-') ?></td>
                <td><?= e($c['billing_city'] ?? '-') ?></td>
                <td><?= $c['invoice_count'] ?></td>
                <td><?= formatMoney($c['open_balance']) ?></td>
                <td class="text-end">
                    <a href="/customers/edit?id=<?= $c['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                </td>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
    <?php if ($result['total_pages'] > 1): ?>
    <div class="card-footer">
        <nav><ul class="pagination pagination-sm mb-0 justify-content-center">
            <?php for ($i = 1; $i <= $result['total_pages']; $i++): ?>
            <li class="page-item <?= $i === $result['page'] ? 'active' : '' ?>">
                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?><?= $showArchived ? '&archived' : '' ?>"><?= $i ?></a>
            </li>
            <?php endfor; ?>
        </ul></nav>
    </div>
    <?php endif; ?>
</div>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Klanten', 'currentPage' => 'customers', 'content' => $content]);
