<?php
// POST /login
$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

if (!$email || !$password) {
    render('auth/login', ['email' => $email, 'error' => 'Vul alle velden in.']);
    exit;
}

// Rate limiting check
$db = Database::get();
$stmt = $db->prepare('SELECT * FROM users WHERE email = ? AND status != ?');
$stmt->execute([$email, 'inactive']);
$user = $stmt->fetch();

if (!$user) {
    AuditLog::log('auth', null, 'login_failed', ['email' => $email], null);
    render('auth/login', ['email' => $email, 'error' => 'Ongeldige inloggegevens.']);
    exit;
}

// Check lockout
if ($user['locked_until'] && strtotime($user['locked_until']) > time()) {
    render('auth/login', ['email' => $email, 'error' => 'Account tijdelijk geblokkeerd. Probeer later opnieuw.']);
    exit;
}

// Verify password
if (!password_verify($password, $user['password_hash'])) {
    $attempts = $user['failed_login_attempts'] + 1;
    $lockUntil = $attempts >= 5 ? date('Y-m-d H:i:s', strtotime('+15 minutes')) : null;

    $stmt = $db->prepare('UPDATE users SET failed_login_attempts = ?, locked_until = ? WHERE id = ?');
    $stmt->execute([$attempts, $lockUntil, $user['id']]);

    AuditLog::log('auth', $user['id'], 'login_failed', ['attempts' => $attempts], null);
    render('auth/login', ['email' => $email, 'error' => 'Ongeldige inloggegevens.']);
    exit;
}

// Successful login
$stmt = $db->prepare('UPDATE users SET failed_login_attempts = 0, locked_until = NULL, last_login_at = NOW() WHERE id = ?');
$stmt->execute([$user['id']]);

// Get role slug
$stmt = $db->prepare('SELECT slug FROM roles WHERE id = ?');
$stmt->execute([$user['role_id']]);
$role = $stmt->fetch();
$user['role_slug'] = $role['slug'] ?? '';

Auth::login($user);
AuditLog::log('auth', $user['id'], 'login_success', null, null);

redirect('/dashboard');
