<?php
// POST /forgot-password
// In production: generate token, send email. For now, just show confirmation.
$email = trim($_POST['email'] ?? '');
if ($email) {
    $db = Database::get();
    $stmt = $db->prepare('SELECT id FROM users WHERE email = ?');
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    if ($user) {
        $token = bin2hex(random_bytes(32));
        $stmt = $db->prepare('UPDATE users SET password_reset_token = ?, password_reset_expires = DATE_ADD(NOW(), INTERVAL 1 HOUR) WHERE id = ?');
        $stmt->execute([$token, $user['id']]);
        // TODO: Send email with reset link
        AuditLog::log('auth', $user['id'], 'password_reset_requested', null, null);
    }
}
render('auth/forgot_password', ['sent' => true]);
