<?php
Auth::requirePermission('audit', 'view');
$db = Database::get();
$page = max(1, (int)($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');
$entity = trim($_GET['entity'] ?? '');
$userId = (int)($_GET['user_id'] ?? 0);

$where = '1=1';
$params = [];

if ($search) {
    $where .= ' AND (al.action LIKE ? OR al.entity LIKE ? OR al.before_json LIKE ? OR al.after_json LIKE ?)';
    $params = array_merge($params, ["%$search%", "%$search%", "%$search%", "%$search%"]);
}
if ($entity) {
    $where .= ' AND al.entity = ?';
    $params[] = $entity;
}
if ($userId) {
    $where .= ' AND al.actor_user_id = ?';
    $params[] = $userId;
}

$query = "SELECT al.*, u.name as user_name, u.email as user_email
          FROM audit_log al
          LEFT JOIN users u ON u.id = al.actor_user_id
          WHERE $where
          ORDER BY al.created_at DESC";
$result = paginate($query, $params, $page, 30);

// Get unique entities for filter
$entities = $db->query("SELECT DISTINCT entity FROM audit_log ORDER BY entity")->fetchAll(PDO::FETCH_COLUMN);

// Get users for filter
$users = $db->query("SELECT id, name FROM users ORDER BY name")->fetchAll();

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-clock-history me-2"></i>Audit Log</h5>
    <small class="text-muted"><?= number_format($result['total']) ?> registraties</small>
</div>

<div class="card">
    <div class="card-header">
        <form method="GET" class="d-flex gap-2 flex-wrap">
            <input type="text" name="search" class="form-control form-control-sm" placeholder="Zoeken..." value="<?= e($search) ?>" style="max-width:200px">
            <select name="entity" class="form-select form-select-sm" style="max-width:160px">
                <option value="">Alle entiteiten</option>
                <?php foreach ($entities as $ent): ?>
                <option value="<?= e($ent) ?>" <?= $entity === $ent ? 'selected' : '' ?>><?= e(ucfirst($ent)) ?></option>
                <?php endforeach; ?>
            </select>
            <select name="user_id" class="form-select form-select-sm" style="max-width:160px">
                <option value="">Alle gebruikers</option>
                <?php foreach ($users as $u): ?>
                <option value="<?= $u['id'] ?>" <?= $userId == $u['id'] ? 'selected' : '' ?>><?= e($u['name']) ?></option>
                <?php endforeach; ?>
            </select>
            <button class="btn btn-sm btn-outline-secondary">Filter</button>
            <?php if ($search || $entity || $userId): ?>
            <a href="/audit" class="btn btn-sm btn-outline-danger">Reset</a>
            <?php endif; ?>
        </form>
    </div>
    <div class="table-responsive">
        <table class="table table-hover table-sm mb-0">
            <thead>
                <tr>
                    <th style="width:140px">Datum/Tijd</th>
                    <th>Gebruiker</th>
                    <th>Entiteit</th>
                    <th>ID</th>
                    <th>Actie</th>
                    <th>IP</th>
                    <th style="width:50px"></th>
                </tr>
            </thead>
            <tbody>
            <?php if (empty($result['items'])): ?>
            <tr><td colspan="7" class="text-center text-muted py-4">Geen audit logs gevonden</td></tr>
            <?php else: foreach ($result['items'] as $log): ?>
            <tr>
                <td class="small"><?= formatDate($log['created_at'], 'd-m-Y H:i:s') ?></td>
                <td>
                    <?php if ($log['user_name']): ?>
                    <span class="fw-medium"><?= e($log['user_name']) ?></span>
                    <?php else: ?>
                    <span class="text-muted">Systeem</span>
                    <?php endif; ?>
                </td>
                <td><span class="badge bg-light text-dark"><?= e(ucfirst($log['entity'])) ?></span></td>
                <td class="small text-muted">#<?= $log['entity_id'] ?></td>
                <td>
                    <?php
                    $actionColors = [
                        'created' => 'success', 'updated' => 'primary', 'deleted' => 'danger',
                        'finalized' => 'info', 'sent' => 'primary', 'archived' => 'warning',
                        'restored' => 'success', 'login' => 'secondary', 'login_failed' => 'danger',
                        'payment_registered' => 'success', 'payment_deleted' => 'danger',
                    ];
                    $color = $actionColors[$log['action']] ?? 'secondary';
                    ?>
                    <span class="badge bg-<?= $color ?>"><?= e($log['action']) ?></span>
                </td>
                <td class="small text-muted"><?= e($log['ip_address'] ?? '-') ?></td>
                <td>
                    <?php if ($log['before_json'] || $log['after_json']): ?>
                    <button class="btn btn-sm btn-outline-secondary py-0 px-1" onclick="toggleDetail(<?= $log['id'] ?>)" title="Details">
                        <i class="bi bi-eye"></i>
                    </button>
                    <?php endif; ?>
                </td>
            </tr>
            <?php if ($log['before_json'] || $log['after_json']): ?>
            <tr id="detail-<?= $log['id'] ?>" style="display:none">
                <td colspan="7" class="bg-light">
                    <div class="row small">
                        <?php if ($log['before_json']): ?>
                        <div class="col-md-6">
                            <strong class="text-danger">Vóór:</strong>
                            <pre class="mt-1 mb-0 p-2 bg-white rounded" style="max-height:200px;overflow:auto;font-size:.75rem"><?= e(json_encode(json_decode($log['before_json']), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ?></pre>
                        </div>
                        <?php endif; ?>
                        <?php if ($log['after_json']): ?>
                        <div class="col-md-6">
                            <strong class="text-success">Na:</strong>
                            <pre class="mt-1 mb-0 p-2 bg-white rounded" style="max-height:200px;overflow:auto;font-size:.75rem"><?= e(json_encode(json_decode($log['after_json']), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ?></pre>
                        </div>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <?php endif; ?>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
    <?php if ($result['total_pages'] > 1): ?>
    <div class="card-footer">
        <nav><ul class="pagination pagination-sm mb-0 justify-content-center">
            <?php if ($result['page'] > 1): ?>
            <li class="page-item"><a class="page-link" href="?page=<?= $result['page'] - 1 ?>&search=<?= urlencode($search) ?>&entity=<?= urlencode($entity) ?>&user_id=<?= $userId ?>">«</a></li>
            <?php endif; ?>
            <?php
            $start = max(1, $result['page'] - 3);
            $end = min($result['total_pages'], $result['page'] + 3);
            for ($i = $start; $i <= $end; $i++):
            ?>
            <li class="page-item <?= $i === $result['page'] ? 'active' : '' ?>">
                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>&entity=<?= urlencode($entity) ?>&user_id=<?= $userId ?>"><?= $i ?></a>
            </li>
            <?php endfor; ?>
            <?php if ($result['page'] < $result['total_pages']): ?>
            <li class="page-item"><a class="page-link" href="?page=<?= $result['page'] + 1 ?>&search=<?= urlencode($search) ?>&entity=<?= urlencode($entity) ?>&user_id=<?= $userId ?>">»</a></li>
            <?php endif; ?>
        </ul></nav>
    </div>
    <?php endif; ?>
</div>

<script>
function toggleDetail(id) {
    const row = document.getElementById('detail-' + id);
    row.style.display = row.style.display === 'none' ? '' : 'none';
}
</script>
<?php
$content = ob_get_clean();
render('layouts/app', ['pageTitle' => 'Audit Log', 'currentPage' => 'audit', 'content' => $content]);
