<?php
header('Content-Type: application/json');
if (!Auth::check()) { http_response_code(401); echo json_encode(['error' => 'Unauthorized']); exit; }

$db = Database::get();
$q = trim($_GET['q'] ?? '');

if (strlen($q) < 1) {
    echo json_encode([]);
    exit;
}

$stmt = $db->prepare(
    "SELECT i.id, i.sku, i.name, i.description, i.unit_price, i.unit, t.rate as tax_rate, t.name as tax_name
     FROM items i 
     LEFT JOIN tax_codes t ON t.id = i.tax_code_id
     WHERE i.active = 1 AND (i.name LIKE ? OR i.sku LIKE ? OR i.description LIKE ?)
     ORDER BY i.name LIMIT 20"
);
$search = "%$q%";
$stmt->execute([$search, $search, $search]);
echo json_encode($stmt->fetchAll());
