<?php
header('Content-Type: application/json');
if (!Auth::check()) { http_response_code(401); echo json_encode(['error' => 'Unauthorized']); exit; }

$db = Database::get();
$q = trim($_GET['q'] ?? '');

if (strlen($q) < 1) {
    echo json_encode([]);
    exit;
}

$stmt = $db->prepare(
    "SELECT id, name, company_name, email, billing_city, payment_terms, currency, language
     FROM customers 
     WHERE archived_at IS NULL AND (name LIKE ? OR company_name LIKE ? OR email LIKE ?)
     ORDER BY name LIMIT 20"
);
$search = "%$q%";
$stmt->execute([$search, $search, $search]);
echo json_encode($stmt->fetchAll());
