-- =====================================================
-- Seed Data - Invoice PHP Standalone Webapp
-- =====================================================

-- Roles
INSERT INTO `roles` (`name`, `slug`, `description`) VALUES
('Administrator', 'admin', 'Volledige toegang tot alle modules'),
('Finance', 'finance', 'Facturen, betalingen, rapportages, herinneringen'),
('Sales', 'sales', 'Offertes, klanten, conceptfacturen'),
('Viewer', 'viewer', 'Alleen-lezen toegang');

-- Permissions
INSERT INTO `permissions` (`module`, `action`, `description`) VALUES
-- Users
('users', 'view', 'Gebruikers bekijken'),
('users', 'create', 'Gebruikers aanmaken'),
('users', 'edit', 'Gebruikers bewerken'),
('users', 'delete', 'Gebruikers verwijderen'),
-- Settings
('settings', 'view', 'Instellingen bekijken'),
('settings', 'edit', 'Instellingen wijzigen'),
-- Customers
('customers', 'view', 'Klanten bekijken'),
('customers', 'create', 'Klanten aanmaken'),
('customers', 'edit', 'Klanten bewerken'),
('customers', 'archive', 'Klanten archiveren'),
-- Items
('items', 'view', 'Producten bekijken'),
('items', 'create', 'Producten aanmaken'),
('items', 'edit', 'Producten bewerken'),
('items', 'delete', 'Producten verwijderen'),
-- Quotes
('quotes', 'view', 'Offertes bekijken'),
('quotes', 'create', 'Offertes aanmaken'),
('quotes', 'edit', 'Offertes bewerken'),
('quotes', 'send', 'Offertes verzenden'),
('quotes', 'convert', 'Offerte omzetten naar factuur'),
-- Invoices
('invoices', 'view', 'Facturen bekijken'),
('invoices', 'create', 'Facturen aanmaken'),
('invoices', 'edit', 'Facturen bewerken'),
('invoices', 'finalize', 'Facturen definitief maken'),
('invoices', 'send', 'Facturen verzenden'),
-- Credits
('credits', 'view', 'Creditnota\'s bekijken'),
('credits', 'create', 'Creditnota\'s aanmaken'),
('credits', 'finalize', 'Creditnota\'s definitief maken'),
-- Payments
('payments', 'view', 'Betalingen bekijken'),
('payments', 'create', 'Betalingen registreren'),
('payments', 'delete', 'Betalingen verwijderen'),
-- Reports
('reports', 'view', 'Rapportages bekijken'),
('reports', 'export', 'Rapportages exporteren'),
-- Reminders
('reminders', 'view', 'Herinneringen bekijken'),
('reminders', 'send', 'Herinneringen versturen'),
('reminders', 'configure', 'Herinneringsinstellingen wijzigen'),
-- Audit
('audit', 'view', 'Audit trail bekijken');

-- Admin gets all permissions
INSERT INTO `role_permissions` (`role_id`, `permission_id`)
SELECT 1, id FROM `permissions`;

-- Finance permissions
INSERT INTO `role_permissions` (`role_id`, `permission_id`)
SELECT 2, id FROM `permissions` WHERE `module` IN ('customers','items','invoices','credits','payments','reports','reminders','audit') AND `action` != 'delete';

-- Sales permissions
INSERT INTO `role_permissions` (`role_id`, `permission_id`)
SELECT 3, id FROM `permissions` WHERE 
  (`module` = 'customers' AND `action` IN ('view','create','edit'))
  OR (`module` = 'items' AND `action` = 'view')
  OR (`module` = 'quotes')
  OR (`module` = 'invoices' AND `action` IN ('view','create','edit'))
  OR (`module` = 'reports' AND `action` = 'view');

-- Viewer permissions
INSERT INTO `role_permissions` (`role_id`, `permission_id`)
SELECT 4, id FROM `permissions` WHERE `action` = 'view';

-- Default Tax Codes (NL)
INSERT INTO `tax_codes` (`name`, `rate`, `code`, `description`, `is_default`) VALUES
('BTW Hoog', 21.00, 'NL_HIGH', 'Nederlands BTW hoog tarief', 1),
('BTW Laag', 9.00, 'NL_LOW', 'Nederlands BTW laag tarief', 0),
('BTW Vrijgesteld', 0.00, 'NL_EXEMPT', 'Vrijgesteld van BTW', 0),
('EU Verlegd', 0.00, 'EU_REVERSE', 'BTW verlegd (intracommunautair)', 0),
('Geen BTW', 0.00, 'NONE', 'Geen BTW van toepassing', 0);

-- Default Settings
INSERT INTO `settings` (`setting_key`, `setting_value`, `setting_group`) VALUES
-- Company
('company_name', 'Mijn Bedrijf B.V.', 'company'),
('company_kvk', '', 'company'),
('company_vat_number', '', 'company'),
('company_iban', '', 'company'),
('company_bic', '', 'company'),
('company_street', '', 'company'),
('company_city', '', 'company'),
('company_postal_code', '', 'company'),
('company_country', 'NL', 'company'),
('company_phone', '', 'company'),
('company_email', '', 'company'),
('company_website', '', 'company'),
('company_logo_path', '', 'company'),
-- Invoice settings
('invoice_prefix', 'FAC', 'invoice'),
('invoice_year_prefix', '1', 'invoice'),
('invoice_next_number', '1', 'invoice'),
('invoice_number_padding', '4', 'invoice'),
('invoice_default_payment_terms', '30', 'invoice'),
('invoice_default_currency', 'EUR', 'invoice'),
('invoice_default_language', 'nl', 'invoice'),
('invoice_footer_text', '', 'invoice'),
-- Quote settings
('quote_prefix', 'OFF', 'quote'),
('quote_next_number', '1', 'quote'),
('quote_number_padding', '4', 'quote'),
('quote_default_validity_days', '30', 'quote'),
-- Credit settings
('credit_prefix', 'CN', 'credit'),
('credit_next_number', '1', 'credit'),
('credit_number_padding', '4', 'credit'),
-- Email/SMTP
('smtp_host', '', 'email'),
('smtp_port', '587', 'email'),
('smtp_username', '', 'email'),
('smtp_password', '', 'email'),
('smtp_encryption', 'tls', 'email'),
('smtp_from_email', '', 'email'),
('smtp_from_name', '', 'email'),
-- Reminders
('reminder_r1_days', '7', 'reminder'),
('reminder_r2_days', '14', 'reminder'),
('reminder_r3_days', '30', 'reminder'),
('reminder_r3_add_costs', '0', 'reminder'),
('reminder_r3_cost_amount', '40.00', 'reminder'),
('reminder_auto_enabled', '0', 'reminder'),
-- PDF
('pdf_template', 'default', 'pdf'),
('pdf_primary_color', '#2563eb', 'pdf'),
('pdf_font', 'dejavusans', 'pdf');

-- Default admin user (password: admin123 - CHANGE IMMEDIATELY)
INSERT INTO `users` (`name`, `email`, `password_hash`, `role_id`, `status`) VALUES
('Administrator', 'admin@example.com', '$2y$12$LJ3m4ys3Gf.N2bCGOGKHBu8tKjBNzOhfEUv3GBcFHs4Y/L7MS0Kq6', 1, 'active');

-- Default reminder templates
INSERT INTO `reminder_templates` (`stage`, `language`, `subject`, `body`) VALUES
('R1', 'nl', 'Herinnering: Factuur {{invoice_number}} openstaand', 
'Geachte {{customer_name}},\n\nGraag herinneren wij u aan de openstaande factuur {{invoice_number}} met een bedrag van {{amount_due}} {{currency}}.\nDe vervaldatum was {{due_date}}.\n\nWij verzoeken u vriendelijk het openstaande bedrag zo spoedig mogelijk over te maken.\n\n{{payment_link}}\n\nMet vriendelijke groet,\n{{company_name}}'),

('R2', 'nl', 'Tweede herinnering: Factuur {{invoice_number}}',
'Geachte {{customer_name}},\n\nOndanks onze eerdere herinnering staat factuur {{invoice_number}} nog steeds open.\nHet openstaande bedrag bedraagt {{amount_due}} {{currency}} (vervaldatum: {{due_date}}).\n\nWij verzoeken u dringend het bedrag binnen 7 dagen over te maken.\n\n{{payment_link}}\n\nMet vriendelijke groet,\n{{company_name}}'),

('R3', 'nl', 'Laatste aanmaning: Factuur {{invoice_number}}',
'Geachte {{customer_name}},\n\nDit is onze laatste aanmaning voor factuur {{invoice_number}}.\nHet openstaande bedrag bedraagt {{amount_due}} {{currency}} (vervaldatum: {{due_date}}).\n\nIndien wij geen betaling ontvangen binnen 7 dagen, zijn wij genoodzaakt verdere maatregelen te nemen.\n\n{{payment_link}}\n\nMet vriendelijke groet,\n{{company_name}}'),

('R1', 'en', 'Reminder: Invoice {{invoice_number}} overdue',
'Dear {{customer_name}},\n\nThis is a friendly reminder that invoice {{invoice_number}} for {{amount_due}} {{currency}} is overdue.\nThe due date was {{due_date}}.\n\nPlease arrange payment at your earliest convenience.\n\n{{payment_link}}\n\nKind regards,\n{{company_name}}'),

('R2', 'en', 'Second reminder: Invoice {{invoice_number}}',
'Dear {{customer_name}},\n\nDespite our previous reminder, invoice {{invoice_number}} remains unpaid.\nThe outstanding amount is {{amount_due}} {{currency}} (due date: {{due_date}}).\n\nPlease arrange payment within 7 days.\n\n{{payment_link}}\n\nKind regards,\n{{company_name}}'),

('R3', 'en', 'Final notice: Invoice {{invoice_number}}',
'Dear {{customer_name}},\n\nThis is our final notice regarding invoice {{invoice_number}}.\nThe outstanding amount is {{amount_due}} {{currency}} (due date: {{due_date}}).\n\nIf payment is not received within 7 days, we will be forced to take further action.\n\n{{payment_link}}\n\nKind regards,\n{{company_name}}');
